% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ini_node.R
\name{predict_dipm}
\alias{predict_dipm}
\title{Prediction of Optimal Treatment}
\usage{
predict_dipm(tree, newdata)
}
\arguments{
\item{tree}{A \code{party} tree object returned from either the 
\code{dipm()} or \code{spmtree()} function}

\item{newdata}{A matrix or data frame of the new data}
}
\value{
\code{predict.dipm} returns the predicted optimal 
treatment for a new subject
}
\description{
This function predicts the optimal treatment 
for a new subject based on either \code{dipm} or \code{spmtree}.
}
\details{
This function implements the optimal treatment 
prediction proposed in Chen and Zhang (2020a, b).
}
\examples{

#
# ... an example with a continuous outcome variable
#     and two treatment groups
#

N=100
set.seed(123)

# generate binary treatments
treatment=rbinom(N,1,0.5)

# generate candidate split variables
X1=rnorm(n=N,mean=0,sd=1)
X2=rnorm(n=N,mean=0,sd=1)
X3=rnorm(n=N,mean=0,sd=1)
X4=rnorm(n=N,mean=0,sd=1)
X5=rnorm(n=N,mean=0,sd=1)
X=cbind(X1,X2,X3,X4,X5)
colnames(X)=paste0("X",1:5)

# generate continuous outcome variable
calculateLink <- function(X,treatment) {

    ( (X[,1] <= 0) & (X[,2] <= 0) )*
        ( 25*(1-treatment) + 8*treatment) + 

    ( (X[,1] <= 0) & (X[,2] > 0) )*
        ( 18*(1-treatment) + 20*treatment ) +

    ( (X[,1] > 0) & (X[,3] <= 0) )*
        ( 20*(1-treatment) + 18*treatment ) + 

    ( (X[,1] > 0) & (X[,3] > 0) )*
        ( 8*(1-treatment) + 25*treatment )
}

Link=calculateLink(X,treatment)
Y=rnorm(N,mean=Link,sd=1)

# combine variables in a data frame
data=data.frame(X,Y,treatment)

# fit a dipm classification tree
tree=dipm(Y~treatment | .,data,mtry=1,maxdepth=3) 
predict_dipm(tree, newdata = head(data))
          
                                    
}
\references{
Chen, V., Li, C., and Zhang, H. (2021). The dipm R 
            package: implementing the depth importance in 
            precision medicine (DIPM) tree and forest based method.
            \emph{Manuscript}.

            Chen, V. and Zhang, H. (2020). Depth importance in 
            precision medicine (DIPM): a tree and forest based method. 
            In \emph{Contemporary Experimental Design, 
            Multivariate Analysis and Data Mining}, 243-259.

            Chen, V. and Zhang, H. (2020). Depth importance in 
            precision medicine (DIPM): A tree-and forest-based 
            method for right-censored survival outcomes. 
            \emph{Biostatistics}.
}
\seealso{
\code{\link{dipm}}, \code{\link{spmtree}}
}
