% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_function.R
\name{LikelihoodFunction}
\alias{LikelihoodFunction}
\title{The Likelihood function of a Dirichlet process object.}
\usage{
LikelihoodFunction(dpobj, ind)
}
\arguments{
\item{dpobj}{Dirichlet process object.}

\item{ind}{The iteration number. Defaults to the last iteration.}
}
\value{
A function f(x) that represents the Likelihood of the dpobj.
}
\description{
Collecting the fitted cluster parameters and number of datapoints associated with each parameter a likelihood can be calculated.
Each cluster is weighted by the number of datapoints assigned.
}
\examples{
y <- rnorm(10)
dp <- DirichletProcessGaussian(y)
dp <- Fit(dp, 5)
f <- LikelihoodFunction(dp)
plot(f(-2:2))

}
