% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disaggR.R
\docType{package}
\name{disaggR-package}
\alias{disaggR}
\alias{disaggR-package}
\title{Two-Steps Benchmarks for Time Series Disaggregation}
\description{
The \code{twoStepsBenchmark()} and \code{threeRuleSmooth()} functions allow you to
disaggregate a low-frequency time-serie with higher frequency time-series,
using the French National Accounts methodology. The aggregated sum of the
resulting time-serie is strictly equal to the low-frequency serie within the
benchmarking window. Typically, the low-frequency serie is an annual one,
unknown for the last year, and the high frequency one is either quarterly or
monthly.

See "Methodology of quarterly national accounts", Insee Méthodes
N°126, by Insee (2012, ISBN:978-2-11-068613-8,
https://www.insee.fr/en/information/2579410).
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/InseeFr/disaggR/issues}
}

}
\author{
\strong{Maintainer}: Thomas Laurent \email{thomas.laurent@insee.fr}

Authors:
\itemize{
  \item Arnaud Feldmann \email{arnaud.feldmann@gmail.com} (\href{https://orcid.org/0000-0003-0109-7505}{ORCID}) (Author, creator and maintener of the package until the version 1.0.2)
}

Other contributors:
\itemize{
  \item Franck Arnaud (barplot base graphics method for the mts class) [contributor]
  \item Institut national de la statistique et des études économiques \email{comptes-trimestriels@insee.fr} (https://www.insee.fr/) [copyright holder]
}

}
\keyword{internal}
