// Generated by rstantools.  Do not edit by hand.

/*
    disbayes is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    disbayes is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with disbayes.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_disbayes_hier_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_disbayes_hier");
    reader.add_event(0, 0, "include", "/include/trans_probs.stan");
    reader.add_event(0, 0, "start", "/include/trans_probs.stan");
    reader.add_event(100, 100, "end", "/include/trans_probs.stan");
    reader.add_event(100, 1, "restart", "model_disbayes_hier");
    reader.add_event(510, 409, "end", "model_disbayes_hier");
    return reader;
}
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
trans_probs_rem(const T0__& i,
                    const T1__& f,
                    const T2__& r, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 10;
        local_scalar_t__ l(DUMMY_VAR__);
        (void) l;  // dummy to suppress unused var warning
        stan::math::initialize(l, DUMMY_VAR__);
        stan::math::fill(l, DUMMY_VAR__);
        stan::math::assign(l,((i + r) + f));
        current_statement_begin__ = 11;
        local_scalar_t__ q(DUMMY_VAR__);
        (void) q;  // dummy to suppress unused var warning
        stan::math::initialize(q, DUMMY_VAR__);
        stan::math::fill(q, DUMMY_VAR__);
        stan::math::assign(q,stan::math::sqrt(((((((i * i) + ((2 * i) * r)) - ((2 * i) * f)) + (r * r)) + ((2 * f) * r)) + (f * f))));
        current_statement_begin__ = 12;
        local_scalar_t__ w(DUMMY_VAR__);
        (void) w;  // dummy to suppress unused var warning
        stan::math::initialize(w, DUMMY_VAR__);
        stan::math::fill(w, DUMMY_VAR__);
        stan::math::assign(w,stan::math::exp((-((l + q)) / 2)));
        current_statement_begin__ = 13;
        local_scalar_t__ v(DUMMY_VAR__);
        (void) v;  // dummy to suppress unused var warning
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);
        stan::math::assign(v,stan::math::exp((-((l - q)) / 2)));
        current_statement_begin__ = 14;
        validate_non_negative_index("P", "3", 3);
        validate_non_negative_index("P", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        current_statement_begin__ = 15;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    (((((2 * (v - w)) * (f + r)) + (v * (q - l))) + (w * (q + l))) / (2 * q)), 
                    "assigning variable P");
        current_statement_begin__ = 16;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    (((v - w) * r) / q), 
                    "assigning variable P");
        current_statement_begin__ = 17;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 19;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    ((i * (v - w)) / q), 
                    "assigning variable P");
        current_statement_begin__ = 20;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    (-(((((2 * (f + r)) - l) * (v - w)) - (q * (v + w)))) / (2 * q)), 
                    "assigning variable P");
        current_statement_begin__ = 21;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 23;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    ((((-(l) * (v - w)) - (q * (v + w))) / (2 * q)) + 1), 
                    "assigning variable P");
        current_statement_begin__ = 24;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    (((((v - w) * ((2 * f) - l)) - (q * (v + w))) / (2 * q)) + 1), 
                    "assigning variable P");
        current_statement_begin__ = 25;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    1, 
                    "assigning variable P");
        current_statement_begin__ = 26;
        return stan::math::promote_scalar<fun_return_scalar_t__>(P);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct trans_probs_rem_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& i,
                    const T1__& f,
                    const T2__& r, std::ostream* pstream__) const {
        return trans_probs_rem(i, f, r, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, Eigen::Dynamic>
trans_probs_norem_if(const T0__& i,
                         const T1__& f, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 30;
        local_scalar_t__ l(DUMMY_VAR__);
        (void) l;  // dummy to suppress unused var warning
        stan::math::initialize(l, DUMMY_VAR__);
        stan::math::fill(l, DUMMY_VAR__);
        stan::math::assign(l,(i + f));
        current_statement_begin__ = 31;
        local_scalar_t__ q(DUMMY_VAR__);
        (void) q;  // dummy to suppress unused var warning
        stan::math::initialize(q, DUMMY_VAR__);
        stan::math::fill(q, DUMMY_VAR__);
        stan::math::assign(q,stan::math::sqrt((((i * i) - ((2 * i) * f)) + (f * f))));
        current_statement_begin__ = 32;
        local_scalar_t__ w(DUMMY_VAR__);
        (void) w;  // dummy to suppress unused var warning
        stan::math::initialize(w, DUMMY_VAR__);
        stan::math::fill(w, DUMMY_VAR__);
        stan::math::assign(w,stan::math::exp((-((l + q)) / 2)));
        current_statement_begin__ = 33;
        local_scalar_t__ v(DUMMY_VAR__);
        (void) v;  // dummy to suppress unused var warning
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);
        stan::math::assign(v,stan::math::exp((-((l - q)) / 2)));
        current_statement_begin__ = 34;
        validate_non_negative_index("P", "3", 3);
        validate_non_negative_index("P", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        current_statement_begin__ = 35;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    (((((2 * (v - w)) * f) + (v * (q - l))) + (w * (q + l))) / (2 * q)), 
                    "assigning variable P");
        current_statement_begin__ = 36;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 37;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 39;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    ((i * (v - w)) / q), 
                    "assigning variable P");
        current_statement_begin__ = 40;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    (-(((((2 * f) - l) * (v - w)) - (q * (v + w)))) / (2 * q)), 
                    "assigning variable P");
        current_statement_begin__ = 41;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 43;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    ((((-(l) * (v - w)) - (q * (v + w))) / (2 * q)) + 1), 
                    "assigning variable P");
        current_statement_begin__ = 44;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    (((((v - w) * ((2 * f) - l)) - (q * (v + w))) / (2 * q)) + 1), 
                    "assigning variable P");
        current_statement_begin__ = 45;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    1, 
                    "assigning variable P");
        current_statement_begin__ = 46;
        return stan::math::promote_scalar<fun_return_scalar_t__>(P);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct trans_probs_norem_if_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& i,
                         const T1__& f, std::ostream* pstream__) const {
        return trans_probs_norem_if(i, f, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
trans_probs_norem_i(const T0__& i, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 50;
        validate_non_negative_index("P", "3", 3);
        validate_non_negative_index("P", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        current_statement_begin__ = 51;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    stan::math::exp(-(i)), 
                    "assigning variable P");
        current_statement_begin__ = 52;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    (i * stan::math::exp(-(i))), 
                    "assigning variable P");
        current_statement_begin__ = 53;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    ((-(stan::math::exp(-(i))) + 1) - (i * stan::math::exp(-(i)))), 
                    "assigning variable P");
        current_statement_begin__ = 55;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 56;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    stan::math::exp(-(i)), 
                    "assigning variable P");
        current_statement_begin__ = 57;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    (1 - stan::math::exp(-(i))), 
                    "assigning variable P");
        current_statement_begin__ = 59;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 60;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 61;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    1, 
                    "assigning variable P");
        current_statement_begin__ = 62;
        return stan::math::promote_scalar<fun_return_scalar_t__>(P);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct trans_probs_norem_i_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& i, std::ostream* pstream__) const {
        return trans_probs_norem_i(i, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
defuzz_P(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& P, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 66;
        validate_non_negative_index("Pr", "3", 3);
        validate_non_negative_index("Pr", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Pr(3, 3);
        stan::math::initialize(Pr, DUMMY_VAR__);
        stan::math::fill(Pr, DUMMY_VAR__);
        current_statement_begin__ = 67;
        for (int r = 1; r <= 3; ++r) {
            current_statement_begin__ = 68;
            for (int s = 1; s <= 3; ++s) {
                current_statement_begin__ = 69;
                stan::model::assign(Pr, 
                            stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list())), 
                            get_base1(P, r, s, "P", 1), 
                            "assigning variable Pr");
                current_statement_begin__ = 70;
                if (as_bool(logical_lt(get_base1(P, r, s, "P", 1), 0))) {
                    current_statement_begin__ = 70;
                    stan::model::assign(Pr, 
                                stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable Pr");
                }
                current_statement_begin__ = 71;
                if (as_bool(logical_gt(get_base1(P, r, s, "P", 1), 1))) {
                    current_statement_begin__ = 71;
                    stan::model::assign(Pr, 
                                stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list())), 
                                1, 
                                "assigning variable Pr");
                }
            }
        }
        current_statement_begin__ = 74;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Pr);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct defuzz_P_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& P, std::ostream* pstream__) const {
        return defuzz_P(P, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
trans_probs(const T0__& i,
                const T1__& f,
                const T2__& r, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 78;
        validate_non_negative_index("P", "3", 3);
        validate_non_negative_index("P", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        current_statement_begin__ = 79;
        if (as_bool(logical_neq(r, 0))) {
            current_statement_begin__ = 80;
            stan::math::assign(P, trans_probs_rem(i, f, r, pstream__));
        } else {
            current_statement_begin__ = 82;
            if (as_bool(logical_eq(i, f))) {
                current_statement_begin__ = 83;
                stan::math::assign(P, trans_probs_norem_i(i, pstream__));
            } else {
                current_statement_begin__ = 85;
                stan::math::assign(P, trans_probs_norem_if(i, f, pstream__));
            }
        }
        current_statement_begin__ = 87;
        return stan::math::promote_scalar<fun_return_scalar_t__>(defuzz_P(P, pstream__));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct trans_probs_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& i,
                const T1__& f,
                const T2__& r, std::ostream* pstream__) const {
        return trans_probs(i, f, r, pstream__);
    }
};
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
bound_prob(const T0__& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 91;
        local_scalar_t__ ret(DUMMY_VAR__);
        (void) ret;  // dummy to suppress unused var warning
        stan::math::initialize(ret, DUMMY_VAR__);
        stan::math::fill(ret, DUMMY_VAR__);
        current_statement_begin__ = 92;
        if (as_bool(logical_gte(x, 1))) {
            current_statement_begin__ = 93;
            stan::math::assign(ret, (1 - stan::math::machine_precision()));
        } else if (as_bool(logical_lte(x, 0))) {
            current_statement_begin__ = 95;
            stan::math::assign(ret, stan::math::machine_precision());
        } else {
            current_statement_begin__ = 96;
            stan::math::assign(ret, x);
        }
        current_statement_begin__ = 97;
        return stan::math::promote_scalar<fun_return_scalar_t__>(x);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct bound_prob_functor__ {
    template <typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& x, std::ostream* pstream__) const {
        return bound_prob(x, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_disbayes_hier
  : public stan::model::model_base_crtp<model_disbayes_hier> {
private:
        int nage;
        int narea;
        int ng;
        int eqage;
        int remission;
        int prev_zero;
        std::vector<std::vector<std::vector<int> > > mort_num;
        std::vector<std::vector<std::vector<int> > > mort_denom;
        std::vector<std::vector<std::vector<int> > > prev_num;
        std::vector<std::vector<std::vector<int> > > prev_denom;
        std::vector<std::vector<std::vector<int> > > inc_num;
        std::vector<std::vector<std::vector<int> > > inc_denom;
        std::vector<std::vector<std::vector<int> > > rem_num;
        std::vector<std::vector<std::vector<int> > > rem_denom;
        int K;
        matrix_d X;
        std::vector<double> sprior;
        double mipm;
        double mips;
        double mism;
        double miss;
        double gpint_a;
        double gpint_b;
        double gpslope_a;
        double gpslope_b;
        double gender_int_priorsd;
        double gender_slope_priorsd;
        int interceptonly;
        int increasing;
        int common;
        int const_cf;
        int const_rem;
        int smooth_inc;
        int smooth_rem;
        int sd_int_isfixed;
        int sd_slope_isfixed;
        double sd_int_fixed;
        double sd_slope_fixed;
        std::vector<double> inc_prior;
        std::vector<double> rem_prior;
        int scf_isfixed;
        int scfmale_isfixed;
        int sinc_isfixed;
        int srem_isfixed;
        double lambda_cf_fixed;
        double lambda_cf_male_fixed;
        double lambda_inc_fixed;
        double lambda_rem_fixed;
public:
    model_disbayes_hier(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_disbayes_hier(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_disbayes_hier_namespace::model_disbayes_hier";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 105;
            context__.validate_dims("data initialization", "nage", "int", context__.to_vec());
            nage = int(0);
            vals_i__ = context__.vals_i("nage");
            pos__ = 0;
            nage = vals_i__[pos__++];
            check_greater_or_equal(function__, "nage", nage, 0);
            current_statement_begin__ = 106;
            context__.validate_dims("data initialization", "narea", "int", context__.to_vec());
            narea = int(0);
            vals_i__ = context__.vals_i("narea");
            pos__ = 0;
            narea = vals_i__[pos__++];
            check_greater_or_equal(function__, "narea", narea, 0);
            current_statement_begin__ = 107;
            context__.validate_dims("data initialization", "ng", "int", context__.to_vec());
            ng = int(0);
            vals_i__ = context__.vals_i("ng");
            pos__ = 0;
            ng = vals_i__[pos__++];
            check_greater_or_equal(function__, "ng", ng, 0);
            current_statement_begin__ = 108;
            context__.validate_dims("data initialization", "eqage", "int", context__.to_vec());
            eqage = int(0);
            vals_i__ = context__.vals_i("eqage");
            pos__ = 0;
            eqage = vals_i__[pos__++];
            check_greater_or_equal(function__, "eqage", eqage, 0);
            current_statement_begin__ = 109;
            context__.validate_dims("data initialization", "remission", "int", context__.to_vec());
            remission = int(0);
            vals_i__ = context__.vals_i("remission");
            pos__ = 0;
            remission = vals_i__[pos__++];
            current_statement_begin__ = 110;
            context__.validate_dims("data initialization", "prev_zero", "int", context__.to_vec());
            prev_zero = int(0);
            vals_i__ = context__.vals_i("prev_zero");
            pos__ = 0;
            prev_zero = vals_i__[pos__++];
            current_statement_begin__ = 111;
            validate_non_negative_index("mort_num", "nage", nage);
            validate_non_negative_index("mort_num", "narea", narea);
            validate_non_negative_index("mort_num", "ng", ng);
            context__.validate_dims("data initialization", "mort_num", "int", context__.to_vec(nage,narea,ng));
            mort_num = std::vector<std::vector<std::vector<int> > >(nage, std::vector<std::vector<int> >(narea, std::vector<int>(ng, int(0))));
            vals_i__ = context__.vals_i("mort_num");
            pos__ = 0;
            size_t mort_num_k_0_max__ = nage;
            size_t mort_num_k_1_max__ = narea;
            size_t mort_num_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < mort_num_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < mort_num_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < mort_num_k_0_max__; ++k_0__) {
                        mort_num[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t mort_num_i_0_max__ = nage;
            size_t mort_num_i_1_max__ = narea;
            size_t mort_num_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < mort_num_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < mort_num_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < mort_num_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "mort_num[i_0__][i_1__][i_2__]", mort_num[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 112;
            validate_non_negative_index("mort_denom", "nage", nage);
            validate_non_negative_index("mort_denom", "narea", narea);
            validate_non_negative_index("mort_denom", "ng", ng);
            context__.validate_dims("data initialization", "mort_denom", "int", context__.to_vec(nage,narea,ng));
            mort_denom = std::vector<std::vector<std::vector<int> > >(nage, std::vector<std::vector<int> >(narea, std::vector<int>(ng, int(0))));
            vals_i__ = context__.vals_i("mort_denom");
            pos__ = 0;
            size_t mort_denom_k_0_max__ = nage;
            size_t mort_denom_k_1_max__ = narea;
            size_t mort_denom_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < mort_denom_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < mort_denom_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < mort_denom_k_0_max__; ++k_0__) {
                        mort_denom[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t mort_denom_i_0_max__ = nage;
            size_t mort_denom_i_1_max__ = narea;
            size_t mort_denom_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < mort_denom_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < mort_denom_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < mort_denom_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "mort_denom[i_0__][i_1__][i_2__]", mort_denom[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 113;
            validate_non_negative_index("prev_num", "nage", nage);
            validate_non_negative_index("prev_num", "narea", narea);
            validate_non_negative_index("prev_num", "ng", ng);
            context__.validate_dims("data initialization", "prev_num", "int", context__.to_vec(nage,narea,ng));
            prev_num = std::vector<std::vector<std::vector<int> > >(nage, std::vector<std::vector<int> >(narea, std::vector<int>(ng, int(0))));
            vals_i__ = context__.vals_i("prev_num");
            pos__ = 0;
            size_t prev_num_k_0_max__ = nage;
            size_t prev_num_k_1_max__ = narea;
            size_t prev_num_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < prev_num_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < prev_num_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < prev_num_k_0_max__; ++k_0__) {
                        prev_num[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t prev_num_i_0_max__ = nage;
            size_t prev_num_i_1_max__ = narea;
            size_t prev_num_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < prev_num_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < prev_num_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < prev_num_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "prev_num[i_0__][i_1__][i_2__]", prev_num[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 114;
            validate_non_negative_index("prev_denom", "nage", nage);
            validate_non_negative_index("prev_denom", "narea", narea);
            validate_non_negative_index("prev_denom", "ng", ng);
            context__.validate_dims("data initialization", "prev_denom", "int", context__.to_vec(nage,narea,ng));
            prev_denom = std::vector<std::vector<std::vector<int> > >(nage, std::vector<std::vector<int> >(narea, std::vector<int>(ng, int(0))));
            vals_i__ = context__.vals_i("prev_denom");
            pos__ = 0;
            size_t prev_denom_k_0_max__ = nage;
            size_t prev_denom_k_1_max__ = narea;
            size_t prev_denom_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < prev_denom_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < prev_denom_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < prev_denom_k_0_max__; ++k_0__) {
                        prev_denom[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t prev_denom_i_0_max__ = nage;
            size_t prev_denom_i_1_max__ = narea;
            size_t prev_denom_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < prev_denom_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < prev_denom_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < prev_denom_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "prev_denom[i_0__][i_1__][i_2__]", prev_denom[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 115;
            validate_non_negative_index("inc_num", "nage", nage);
            validate_non_negative_index("inc_num", "narea", narea);
            validate_non_negative_index("inc_num", "ng", ng);
            context__.validate_dims("data initialization", "inc_num", "int", context__.to_vec(nage,narea,ng));
            inc_num = std::vector<std::vector<std::vector<int> > >(nage, std::vector<std::vector<int> >(narea, std::vector<int>(ng, int(0))));
            vals_i__ = context__.vals_i("inc_num");
            pos__ = 0;
            size_t inc_num_k_0_max__ = nage;
            size_t inc_num_k_1_max__ = narea;
            size_t inc_num_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < inc_num_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < inc_num_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < inc_num_k_0_max__; ++k_0__) {
                        inc_num[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t inc_num_i_0_max__ = nage;
            size_t inc_num_i_1_max__ = narea;
            size_t inc_num_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < inc_num_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < inc_num_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < inc_num_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "inc_num[i_0__][i_1__][i_2__]", inc_num[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 116;
            validate_non_negative_index("inc_denom", "nage", nage);
            validate_non_negative_index("inc_denom", "narea", narea);
            validate_non_negative_index("inc_denom", "ng", ng);
            context__.validate_dims("data initialization", "inc_denom", "int", context__.to_vec(nage,narea,ng));
            inc_denom = std::vector<std::vector<std::vector<int> > >(nage, std::vector<std::vector<int> >(narea, std::vector<int>(ng, int(0))));
            vals_i__ = context__.vals_i("inc_denom");
            pos__ = 0;
            size_t inc_denom_k_0_max__ = nage;
            size_t inc_denom_k_1_max__ = narea;
            size_t inc_denom_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < inc_denom_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < inc_denom_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < inc_denom_k_0_max__; ++k_0__) {
                        inc_denom[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t inc_denom_i_0_max__ = nage;
            size_t inc_denom_i_1_max__ = narea;
            size_t inc_denom_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < inc_denom_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < inc_denom_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < inc_denom_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "inc_denom[i_0__][i_1__][i_2__]", inc_denom[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 117;
            validate_non_negative_index("rem_num", "nage", nage);
            validate_non_negative_index("rem_num", "narea", narea);
            validate_non_negative_index("rem_num", "ng", ng);
            context__.validate_dims("data initialization", "rem_num", "int", context__.to_vec(nage,narea,ng));
            rem_num = std::vector<std::vector<std::vector<int> > >(nage, std::vector<std::vector<int> >(narea, std::vector<int>(ng, int(0))));
            vals_i__ = context__.vals_i("rem_num");
            pos__ = 0;
            size_t rem_num_k_0_max__ = nage;
            size_t rem_num_k_1_max__ = narea;
            size_t rem_num_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < rem_num_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < rem_num_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < rem_num_k_0_max__; ++k_0__) {
                        rem_num[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t rem_num_i_0_max__ = nage;
            size_t rem_num_i_1_max__ = narea;
            size_t rem_num_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < rem_num_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rem_num_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < rem_num_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "rem_num[i_0__][i_1__][i_2__]", rem_num[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 118;
            validate_non_negative_index("rem_denom", "nage", nage);
            validate_non_negative_index("rem_denom", "narea", narea);
            validate_non_negative_index("rem_denom", "ng", ng);
            context__.validate_dims("data initialization", "rem_denom", "int", context__.to_vec(nage,narea,ng));
            rem_denom = std::vector<std::vector<std::vector<int> > >(nage, std::vector<std::vector<int> >(narea, std::vector<int>(ng, int(0))));
            vals_i__ = context__.vals_i("rem_denom");
            pos__ = 0;
            size_t rem_denom_k_0_max__ = nage;
            size_t rem_denom_k_1_max__ = narea;
            size_t rem_denom_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < rem_denom_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < rem_denom_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < rem_denom_k_0_max__; ++k_0__) {
                        rem_denom[k_0__][k_1__][k_2__] = vals_i__[pos__++];
                    }
                }
            }
            size_t rem_denom_i_0_max__ = nage;
            size_t rem_denom_i_1_max__ = narea;
            size_t rem_denom_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < rem_denom_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rem_denom_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < rem_denom_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "rem_denom[i_0__][i_1__][i_2__]", rem_denom[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 120;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 0);
            current_statement_begin__ = 121;
            validate_non_negative_index("X", "nage", nage);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(nage,K));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nage, K);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = K;
            size_t X_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 122;
            validate_non_negative_index("sprior", "3", 3);
            context__.validate_dims("data initialization", "sprior", "double", context__.to_vec(3));
            sprior = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("sprior");
            pos__ = 0;
            size_t sprior_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < sprior_k_0_max__; ++k_0__) {
                sprior[k_0__] = vals_r__[pos__++];
            }
            size_t sprior_i_0_max__ = 3;
            for (size_t i_0__ = 0; i_0__ < sprior_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "sprior[i_0__]", sprior[i_0__], 0);
            }
            current_statement_begin__ = 123;
            context__.validate_dims("data initialization", "mipm", "double", context__.to_vec());
            mipm = double(0);
            vals_r__ = context__.vals_r("mipm");
            pos__ = 0;
            mipm = vals_r__[pos__++];
            current_statement_begin__ = 124;
            context__.validate_dims("data initialization", "mips", "double", context__.to_vec());
            mips = double(0);
            vals_r__ = context__.vals_r("mips");
            pos__ = 0;
            mips = vals_r__[pos__++];
            check_greater_or_equal(function__, "mips", mips, 0);
            current_statement_begin__ = 125;
            context__.validate_dims("data initialization", "mism", "double", context__.to_vec());
            mism = double(0);
            vals_r__ = context__.vals_r("mism");
            pos__ = 0;
            mism = vals_r__[pos__++];
            current_statement_begin__ = 126;
            context__.validate_dims("data initialization", "miss", "double", context__.to_vec());
            miss = double(0);
            vals_r__ = context__.vals_r("miss");
            pos__ = 0;
            miss = vals_r__[pos__++];
            check_greater_or_equal(function__, "miss", miss, 0);
            current_statement_begin__ = 127;
            context__.validate_dims("data initialization", "gpint_a", "double", context__.to_vec());
            gpint_a = double(0);
            vals_r__ = context__.vals_r("gpint_a");
            pos__ = 0;
            gpint_a = vals_r__[pos__++];
            check_greater_or_equal(function__, "gpint_a", gpint_a, 0);
            current_statement_begin__ = 128;
            context__.validate_dims("data initialization", "gpint_b", "double", context__.to_vec());
            gpint_b = double(0);
            vals_r__ = context__.vals_r("gpint_b");
            pos__ = 0;
            gpint_b = vals_r__[pos__++];
            check_greater_or_equal(function__, "gpint_b", gpint_b, 0);
            current_statement_begin__ = 129;
            context__.validate_dims("data initialization", "gpslope_a", "double", context__.to_vec());
            gpslope_a = double(0);
            vals_r__ = context__.vals_r("gpslope_a");
            pos__ = 0;
            gpslope_a = vals_r__[pos__++];
            check_greater_or_equal(function__, "gpslope_a", gpslope_a, 0);
            current_statement_begin__ = 130;
            context__.validate_dims("data initialization", "gpslope_b", "double", context__.to_vec());
            gpslope_b = double(0);
            vals_r__ = context__.vals_r("gpslope_b");
            pos__ = 0;
            gpslope_b = vals_r__[pos__++];
            check_greater_or_equal(function__, "gpslope_b", gpslope_b, 0);
            current_statement_begin__ = 131;
            context__.validate_dims("data initialization", "gender_int_priorsd", "double", context__.to_vec());
            gender_int_priorsd = double(0);
            vals_r__ = context__.vals_r("gender_int_priorsd");
            pos__ = 0;
            gender_int_priorsd = vals_r__[pos__++];
            check_greater_or_equal(function__, "gender_int_priorsd", gender_int_priorsd, 0);
            current_statement_begin__ = 132;
            context__.validate_dims("data initialization", "gender_slope_priorsd", "double", context__.to_vec());
            gender_slope_priorsd = double(0);
            vals_r__ = context__.vals_r("gender_slope_priorsd");
            pos__ = 0;
            gender_slope_priorsd = vals_r__[pos__++];
            check_greater_or_equal(function__, "gender_slope_priorsd", gender_slope_priorsd, 0);
            current_statement_begin__ = 135;
            context__.validate_dims("data initialization", "interceptonly", "int", context__.to_vec());
            interceptonly = int(0);
            vals_i__ = context__.vals_i("interceptonly");
            pos__ = 0;
            interceptonly = vals_i__[pos__++];
            current_statement_begin__ = 136;
            context__.validate_dims("data initialization", "increasing", "int", context__.to_vec());
            increasing = int(0);
            vals_i__ = context__.vals_i("increasing");
            pos__ = 0;
            increasing = vals_i__[pos__++];
            current_statement_begin__ = 137;
            context__.validate_dims("data initialization", "common", "int", context__.to_vec());
            common = int(0);
            vals_i__ = context__.vals_i("common");
            pos__ = 0;
            common = vals_i__[pos__++];
            current_statement_begin__ = 138;
            context__.validate_dims("data initialization", "const_cf", "int", context__.to_vec());
            const_cf = int(0);
            vals_i__ = context__.vals_i("const_cf");
            pos__ = 0;
            const_cf = vals_i__[pos__++];
            current_statement_begin__ = 139;
            context__.validate_dims("data initialization", "const_rem", "int", context__.to_vec());
            const_rem = int(0);
            vals_i__ = context__.vals_i("const_rem");
            pos__ = 0;
            const_rem = vals_i__[pos__++];
            current_statement_begin__ = 140;
            context__.validate_dims("data initialization", "smooth_inc", "int", context__.to_vec());
            smooth_inc = int(0);
            vals_i__ = context__.vals_i("smooth_inc");
            pos__ = 0;
            smooth_inc = vals_i__[pos__++];
            current_statement_begin__ = 141;
            context__.validate_dims("data initialization", "smooth_rem", "int", context__.to_vec());
            smooth_rem = int(0);
            vals_i__ = context__.vals_i("smooth_rem");
            pos__ = 0;
            smooth_rem = vals_i__[pos__++];
            current_statement_begin__ = 144;
            context__.validate_dims("data initialization", "sd_int_isfixed", "int", context__.to_vec());
            sd_int_isfixed = int(0);
            vals_i__ = context__.vals_i("sd_int_isfixed");
            pos__ = 0;
            sd_int_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 145;
            context__.validate_dims("data initialization", "sd_slope_isfixed", "int", context__.to_vec());
            sd_slope_isfixed = int(0);
            vals_i__ = context__.vals_i("sd_slope_isfixed");
            pos__ = 0;
            sd_slope_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 146;
            context__.validate_dims("data initialization", "sd_int_fixed", "double", context__.to_vec());
            sd_int_fixed = double(0);
            vals_r__ = context__.vals_r("sd_int_fixed");
            pos__ = 0;
            sd_int_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "sd_int_fixed", sd_int_fixed, 0);
            current_statement_begin__ = 147;
            context__.validate_dims("data initialization", "sd_slope_fixed", "double", context__.to_vec());
            sd_slope_fixed = double(0);
            vals_r__ = context__.vals_r("sd_slope_fixed");
            pos__ = 0;
            sd_slope_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "sd_slope_fixed", sd_slope_fixed, 0);
            current_statement_begin__ = 148;
            validate_non_negative_index("inc_prior", "2", 2);
            context__.validate_dims("data initialization", "inc_prior", "double", context__.to_vec(2));
            inc_prior = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("inc_prior");
            pos__ = 0;
            size_t inc_prior_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < inc_prior_k_0_max__; ++k_0__) {
                inc_prior[k_0__] = vals_r__[pos__++];
            }
            size_t inc_prior_i_0_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < inc_prior_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "inc_prior[i_0__]", inc_prior[i_0__], 0);
            }
            current_statement_begin__ = 149;
            validate_non_negative_index("rem_prior", "2", 2);
            context__.validate_dims("data initialization", "rem_prior", "double", context__.to_vec(2));
            rem_prior = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("rem_prior");
            pos__ = 0;
            size_t rem_prior_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < rem_prior_k_0_max__; ++k_0__) {
                rem_prior[k_0__] = vals_r__[pos__++];
            }
            size_t rem_prior_i_0_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < rem_prior_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rem_prior[i_0__]", rem_prior[i_0__], 0);
            }
            current_statement_begin__ = 152;
            context__.validate_dims("data initialization", "scf_isfixed", "int", context__.to_vec());
            scf_isfixed = int(0);
            vals_i__ = context__.vals_i("scf_isfixed");
            pos__ = 0;
            scf_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 153;
            context__.validate_dims("data initialization", "scfmale_isfixed", "int", context__.to_vec());
            scfmale_isfixed = int(0);
            vals_i__ = context__.vals_i("scfmale_isfixed");
            pos__ = 0;
            scfmale_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 154;
            context__.validate_dims("data initialization", "sinc_isfixed", "int", context__.to_vec());
            sinc_isfixed = int(0);
            vals_i__ = context__.vals_i("sinc_isfixed");
            pos__ = 0;
            sinc_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 155;
            context__.validate_dims("data initialization", "srem_isfixed", "int", context__.to_vec());
            srem_isfixed = int(0);
            vals_i__ = context__.vals_i("srem_isfixed");
            pos__ = 0;
            srem_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 156;
            context__.validate_dims("data initialization", "lambda_cf_fixed", "double", context__.to_vec());
            lambda_cf_fixed = double(0);
            vals_r__ = context__.vals_r("lambda_cf_fixed");
            pos__ = 0;
            lambda_cf_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_cf_fixed", lambda_cf_fixed, 0);
            current_statement_begin__ = 157;
            context__.validate_dims("data initialization", "lambda_cf_male_fixed", "double", context__.to_vec());
            lambda_cf_male_fixed = double(0);
            vals_r__ = context__.vals_r("lambda_cf_male_fixed");
            pos__ = 0;
            lambda_cf_male_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_cf_male_fixed", lambda_cf_male_fixed, 0);
            current_statement_begin__ = 158;
            context__.validate_dims("data initialization", "lambda_inc_fixed", "double", context__.to_vec());
            lambda_inc_fixed = double(0);
            vals_r__ = context__.vals_r("lambda_inc_fixed");
            pos__ = 0;
            lambda_inc_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_inc_fixed", lambda_inc_fixed, 0);
            current_statement_begin__ = 159;
            context__.validate_dims("data initialization", "lambda_rem_fixed", "double", context__.to_vec());
            lambda_rem_fixed = double(0);
            vals_r__ = context__.vals_r("lambda_rem_fixed");
            pos__ = 0;
            lambda_rem_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_rem_fixed", lambda_rem_fixed, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 163;
            validate_non_negative_index("inc_par", "(nage * (1 - smooth_inc))", (nage * (1 - smooth_inc)));
            validate_non_negative_index("inc_par", "narea", narea);
            validate_non_negative_index("inc_par", "ng", ng);
            num_params_r__ += (((1 * (nage * (1 - smooth_inc))) * narea) * ng);
            current_statement_begin__ = 164;
            validate_non_negative_index("rem_par", "((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)))", ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
            validate_non_negative_index("rem_par", "ng", ng);
            num_params_r__ += ((1 * ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)))) * ng);
            current_statement_begin__ = 167;
            validate_non_negative_index("barea", "((K - 2) * (1 - const_cf))", ((K - 2) * (1 - const_cf)));
            validate_non_negative_index("barea", "((narea * (1 - common)) + (1 * common))", ((narea * (1 - common)) + (1 * common)));
            num_params_r__ += (((K - 2) * (1 - const_cf)) * ((narea * (1 - common)) + (1 * common)));
            current_statement_begin__ = 168;
            validate_non_negative_index("barea_slope", "((1 - interceptonly) * (1 - const_cf))", ((1 - interceptonly) * (1 - const_cf)));
            validate_non_negative_index("barea_slope", "((narea * (1 - common)) + (1 * common))", ((narea * (1 - common)) + (1 * common)));
            num_params_r__ += (((1 - interceptonly) * (1 - const_cf)) * ((narea * (1 - common)) + (1 * common)));
            current_statement_begin__ = 169;
            validate_non_negative_index("barea_inter", "1", 1);
            validate_non_negative_index("barea_inter", "(narea * (1 - common))", (narea * (1 - common)));
            num_params_r__ += (1 * (narea * (1 - common)));
            current_statement_begin__ = 171;
            validate_non_negative_index("bmale", "(K * (ng - 1))", (K * (ng - 1)));
            num_params_r__ += (K * (ng - 1));
            current_statement_begin__ = 174;
            validate_non_negative_index("lcfbase", "(((narea * (1 - common)) + (1 * common)) * increasing)", (((narea * (1 - common)) + (1 * common)) * increasing));
            num_params_r__ += (((narea * (1 - common)) + (1 * common)) * increasing);
            current_statement_begin__ = 176;
            validate_non_negative_index("beta_inc", "(K * smooth_inc)", (K * smooth_inc));
            validate_non_negative_index("beta_inc", "narea", narea);
            validate_non_negative_index("beta_inc", "ng", ng);
            num_params_r__ += (((1 * (K * smooth_inc)) * narea) * ng);
            current_statement_begin__ = 177;
            validate_non_negative_index("beta_rem", "(K * smooth_rem)", (K * smooth_rem));
            validate_non_negative_index("beta_rem", "narea", narea);
            validate_non_negative_index("beta_rem", "ng", ng);
            num_params_r__ += (((1 * (K * smooth_rem)) * narea) * ng);
            current_statement_begin__ = 179;
            num_params_r__ += 1;
            current_statement_begin__ = 180;
            validate_non_negative_index("sd_inter", "(1 - sd_int_isfixed)", (1 - sd_int_isfixed));
            num_params_r__ += (1 - sd_int_isfixed);
            current_statement_begin__ = 181;
            validate_non_negative_index("mean_slope", "(1 - const_cf)", (1 - const_cf));
            num_params_r__ += (1 - const_cf);
            current_statement_begin__ = 182;
            validate_non_negative_index("sd_slope", "((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed))", ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed)));
            num_params_r__ += ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed));
            current_statement_begin__ = 183;
            validate_non_negative_index("lambda_cf", "((1 - const_cf) * (1 - scf_isfixed))", ((1 - const_cf) * (1 - scf_isfixed)));
            num_params_r__ += ((1 - const_cf) * (1 - scf_isfixed));
            current_statement_begin__ = 184;
            validate_non_negative_index("lambda_cf_male", "((ng - 1) * (1 - scfmale_isfixed))", ((ng - 1) * (1 - scfmale_isfixed)));
            num_params_r__ += ((ng - 1) * (1 - scfmale_isfixed));
            current_statement_begin__ = 185;
            validate_non_negative_index("lambda_inc", "(smooth_inc * (1 - sinc_isfixed))", (smooth_inc * (1 - sinc_isfixed)));
            num_params_r__ += (smooth_inc * (1 - sinc_isfixed));
            current_statement_begin__ = 186;
            validate_non_negative_index("lambda_rem", "((remission * smooth_rem) * (1 - srem_isfixed))", ((remission * smooth_rem) * (1 - srem_isfixed)));
            num_params_r__ += ((remission * smooth_rem) * (1 - srem_isfixed));
            current_statement_begin__ = 187;
            validate_non_negative_index("prevzero", "(narea * prev_zero)", (narea * prev_zero));
            validate_non_negative_index("prevzero", "ng", ng);
            num_params_r__ += ((1 * (narea * prev_zero)) * ng);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_disbayes_hier() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 163;
        if (!(context__.contains_r("inc_par")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable inc_par missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("inc_par");
        pos__ = 0U;
        validate_non_negative_index("inc_par", "(nage * (1 - smooth_inc))", (nage * (1 - smooth_inc)));
        validate_non_negative_index("inc_par", "narea", narea);
        validate_non_negative_index("inc_par", "ng", ng);
        context__.validate_dims("parameter initialization", "inc_par", "double", context__.to_vec((nage * (1 - smooth_inc)),narea,ng));
        std::vector<std::vector<std::vector<double> > > inc_par((nage * (1 - smooth_inc)), std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
        size_t inc_par_k_0_max__ = (nage * (1 - smooth_inc));
        size_t inc_par_k_1_max__ = narea;
        size_t inc_par_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < inc_par_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < inc_par_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < inc_par_k_0_max__; ++k_0__) {
                    inc_par[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                }
            }
        }
        size_t inc_par_i_0_max__ = (nage * (1 - smooth_inc));
        size_t inc_par_i_1_max__ = narea;
        size_t inc_par_i_2_max__ = ng;
        for (size_t i_0__ = 0; i_0__ < inc_par_i_0_max__; ++i_0__) {
            for (size_t i_1__ = 0; i_1__ < inc_par_i_1_max__; ++i_1__) {
                for (size_t i_2__ = 0; i_2__ < inc_par_i_2_max__; ++i_2__) {
                    try {
                        writer__.scalar_lb_unconstrain(0, inc_par[i_0__][i_1__][i_2__]);
                    } catch (const std::exception& e) {
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable inc_par: ") + e.what()), current_statement_begin__, prog_reader__());
                    }
                }
            }
        }
        current_statement_begin__ = 164;
        if (!(context__.contains_r("rem_par")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rem_par missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rem_par");
        pos__ = 0U;
        validate_non_negative_index("rem_par", "((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)))", ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
        validate_non_negative_index("rem_par", "ng", ng);
        context__.validate_dims("parameter initialization", "rem_par", "double", context__.to_vec(((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))),ng));
        std::vector<std::vector<double> > rem_par(((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))), std::vector<double>(ng, double(0)));
        size_t rem_par_k_0_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        size_t rem_par_k_1_max__ = ng;
        for (size_t k_1__ = 0; k_1__ < rem_par_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < rem_par_k_0_max__; ++k_0__) {
                rem_par[k_0__][k_1__] = vals_r__[pos__++];
            }
        }
        size_t rem_par_i_0_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        size_t rem_par_i_1_max__ = ng;
        for (size_t i_0__ = 0; i_0__ < rem_par_i_0_max__; ++i_0__) {
            for (size_t i_1__ = 0; i_1__ < rem_par_i_1_max__; ++i_1__) {
                try {
                    writer__.scalar_lb_unconstrain(0, rem_par[i_0__][i_1__]);
                } catch (const std::exception& e) {
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rem_par: ") + e.what()), current_statement_begin__, prog_reader__());
                }
            }
        }
        current_statement_begin__ = 167;
        if (!(context__.contains_r("barea")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable barea missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("barea");
        pos__ = 0U;
        validate_non_negative_index("barea", "((K - 2) * (1 - const_cf))", ((K - 2) * (1 - const_cf)));
        validate_non_negative_index("barea", "((narea * (1 - common)) + (1 * common))", ((narea * (1 - common)) + (1 * common)));
        context__.validate_dims("parameter initialization", "barea", "matrix_d", context__.to_vec(((K - 2) * (1 - const_cf)),((narea * (1 - common)) + (1 * common))));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> barea(((K - 2) * (1 - const_cf)), ((narea * (1 - common)) + (1 * common)));
        size_t barea_j_2_max__ = ((narea * (1 - common)) + (1 * common));
        size_t barea_j_1_max__ = ((K - 2) * (1 - const_cf));
        for (size_t j_2__ = 0; j_2__ < barea_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_j_1_max__; ++j_1__) {
                barea(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(barea);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable barea: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 168;
        if (!(context__.contains_r("barea_slope")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable barea_slope missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("barea_slope");
        pos__ = 0U;
        validate_non_negative_index("barea_slope", "((1 - interceptonly) * (1 - const_cf))", ((1 - interceptonly) * (1 - const_cf)));
        validate_non_negative_index("barea_slope", "((narea * (1 - common)) + (1 * common))", ((narea * (1 - common)) + (1 * common)));
        context__.validate_dims("parameter initialization", "barea_slope", "matrix_d", context__.to_vec(((1 - interceptonly) * (1 - const_cf)),((narea * (1 - common)) + (1 * common))));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> barea_slope(((1 - interceptonly) * (1 - const_cf)), ((narea * (1 - common)) + (1 * common)));
        size_t barea_slope_j_2_max__ = ((narea * (1 - common)) + (1 * common));
        size_t barea_slope_j_1_max__ = ((1 - interceptonly) * (1 - const_cf));
        for (size_t j_2__ = 0; j_2__ < barea_slope_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_slope_j_1_max__; ++j_1__) {
                barea_slope(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(barea_slope);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable barea_slope: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 169;
        if (!(context__.contains_r("barea_inter")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable barea_inter missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("barea_inter");
        pos__ = 0U;
        validate_non_negative_index("barea_inter", "1", 1);
        validate_non_negative_index("barea_inter", "(narea * (1 - common))", (narea * (1 - common)));
        context__.validate_dims("parameter initialization", "barea_inter", "matrix_d", context__.to_vec(1,(narea * (1 - common))));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> barea_inter(1, (narea * (1 - common)));
        size_t barea_inter_j_2_max__ = (narea * (1 - common));
        size_t barea_inter_j_1_max__ = 1;
        for (size_t j_2__ = 0; j_2__ < barea_inter_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_inter_j_1_max__; ++j_1__) {
                barea_inter(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(barea_inter);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable barea_inter: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 171;
        if (!(context__.contains_r("bmale")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable bmale missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("bmale");
        pos__ = 0U;
        validate_non_negative_index("bmale", "(K * (ng - 1))", (K * (ng - 1)));
        context__.validate_dims("parameter initialization", "bmale", "vector_d", context__.to_vec((K * (ng - 1))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> bmale((K * (ng - 1)));
        size_t bmale_j_1_max__ = (K * (ng - 1));
        for (size_t j_1__ = 0; j_1__ < bmale_j_1_max__; ++j_1__) {
            bmale(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(bmale);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable bmale: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 174;
        if (!(context__.contains_r("lcfbase")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lcfbase missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lcfbase");
        pos__ = 0U;
        validate_non_negative_index("lcfbase", "(((narea * (1 - common)) + (1 * common)) * increasing)", (((narea * (1 - common)) + (1 * common)) * increasing));
        context__.validate_dims("parameter initialization", "lcfbase", "vector_d", context__.to_vec((((narea * (1 - common)) + (1 * common)) * increasing)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lcfbase((((narea * (1 - common)) + (1 * common)) * increasing));
        size_t lcfbase_j_1_max__ = (((narea * (1 - common)) + (1 * common)) * increasing);
        for (size_t j_1__ = 0; j_1__ < lcfbase_j_1_max__; ++j_1__) {
            lcfbase(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(lcfbase);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lcfbase: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 176;
        if (!(context__.contains_r("beta_inc")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_inc missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_inc");
        pos__ = 0U;
        validate_non_negative_index("beta_inc", "(K * smooth_inc)", (K * smooth_inc));
        validate_non_negative_index("beta_inc", "narea", narea);
        validate_non_negative_index("beta_inc", "ng", ng);
        context__.validate_dims("parameter initialization", "beta_inc", "double", context__.to_vec((K * smooth_inc),narea,ng));
        std::vector<std::vector<std::vector<double> > > beta_inc((K * smooth_inc), std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
        size_t beta_inc_k_0_max__ = (K * smooth_inc);
        size_t beta_inc_k_1_max__ = narea;
        size_t beta_inc_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < beta_inc_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < beta_inc_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_inc_k_0_max__; ++k_0__) {
                    beta_inc[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                }
            }
        }
        size_t beta_inc_i_0_max__ = (K * smooth_inc);
        size_t beta_inc_i_1_max__ = narea;
        size_t beta_inc_i_2_max__ = ng;
        for (size_t i_0__ = 0; i_0__ < beta_inc_i_0_max__; ++i_0__) {
            for (size_t i_1__ = 0; i_1__ < beta_inc_i_1_max__; ++i_1__) {
                for (size_t i_2__ = 0; i_2__ < beta_inc_i_2_max__; ++i_2__) {
                    try {
                        writer__.scalar_unconstrain(beta_inc[i_0__][i_1__][i_2__]);
                    } catch (const std::exception& e) {
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_inc: ") + e.what()), current_statement_begin__, prog_reader__());
                    }
                }
            }
        }
        current_statement_begin__ = 177;
        if (!(context__.contains_r("beta_rem")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_rem missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_rem");
        pos__ = 0U;
        validate_non_negative_index("beta_rem", "(K * smooth_rem)", (K * smooth_rem));
        validate_non_negative_index("beta_rem", "narea", narea);
        validate_non_negative_index("beta_rem", "ng", ng);
        context__.validate_dims("parameter initialization", "beta_rem", "double", context__.to_vec((K * smooth_rem),narea,ng));
        std::vector<std::vector<std::vector<double> > > beta_rem((K * smooth_rem), std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
        size_t beta_rem_k_0_max__ = (K * smooth_rem);
        size_t beta_rem_k_1_max__ = narea;
        size_t beta_rem_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < beta_rem_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < beta_rem_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_rem_k_0_max__; ++k_0__) {
                    beta_rem[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                }
            }
        }
        size_t beta_rem_i_0_max__ = (K * smooth_rem);
        size_t beta_rem_i_1_max__ = narea;
        size_t beta_rem_i_2_max__ = ng;
        for (size_t i_0__ = 0; i_0__ < beta_rem_i_0_max__; ++i_0__) {
            for (size_t i_1__ = 0; i_1__ < beta_rem_i_1_max__; ++i_1__) {
                for (size_t i_2__ = 0; i_2__ < beta_rem_i_2_max__; ++i_2__) {
                    try {
                        writer__.scalar_unconstrain(beta_rem[i_0__][i_1__][i_2__]);
                    } catch (const std::exception& e) {
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_rem: ") + e.what()), current_statement_begin__, prog_reader__());
                    }
                }
            }
        }
        current_statement_begin__ = 179;
        if (!(context__.contains_r("mean_inter")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mean_inter missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mean_inter");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mean_inter", "double", context__.to_vec());
        double mean_inter(0);
        mean_inter = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mean_inter);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mean_inter: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 180;
        if (!(context__.contains_r("sd_inter")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sd_inter missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sd_inter");
        pos__ = 0U;
        validate_non_negative_index("sd_inter", "(1 - sd_int_isfixed)", (1 - sd_int_isfixed));
        context__.validate_dims("parameter initialization", "sd_inter", "vector_d", context__.to_vec((1 - sd_int_isfixed)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sd_inter((1 - sd_int_isfixed));
        size_t sd_inter_j_1_max__ = (1 - sd_int_isfixed);
        for (size_t j_1__ = 0; j_1__ < sd_inter_j_1_max__; ++j_1__) {
            sd_inter(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sd_inter);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sd_inter: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 181;
        if (!(context__.contains_r("mean_slope")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mean_slope missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mean_slope");
        pos__ = 0U;
        validate_non_negative_index("mean_slope", "(1 - const_cf)", (1 - const_cf));
        context__.validate_dims("parameter initialization", "mean_slope", "vector_d", context__.to_vec((1 - const_cf)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mean_slope((1 - const_cf));
        size_t mean_slope_j_1_max__ = (1 - const_cf);
        for (size_t j_1__ = 0; j_1__ < mean_slope_j_1_max__; ++j_1__) {
            mean_slope(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(mean_slope);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mean_slope: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 182;
        if (!(context__.contains_r("sd_slope")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sd_slope missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sd_slope");
        pos__ = 0U;
        validate_non_negative_index("sd_slope", "((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed))", ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed)));
        context__.validate_dims("parameter initialization", "sd_slope", "vector_d", context__.to_vec(((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sd_slope(((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed)));
        size_t sd_slope_j_1_max__ = ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed));
        for (size_t j_1__ = 0; j_1__ < sd_slope_j_1_max__; ++j_1__) {
            sd_slope(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sd_slope);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sd_slope: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 183;
        if (!(context__.contains_r("lambda_cf")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_cf missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_cf");
        pos__ = 0U;
        validate_non_negative_index("lambda_cf", "((1 - const_cf) * (1 - scf_isfixed))", ((1 - const_cf) * (1 - scf_isfixed)));
        context__.validate_dims("parameter initialization", "lambda_cf", "vector_d", context__.to_vec(((1 - const_cf) * (1 - scf_isfixed))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_cf(((1 - const_cf) * (1 - scf_isfixed)));
        size_t lambda_cf_j_1_max__ = ((1 - const_cf) * (1 - scf_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_j_1_max__; ++j_1__) {
            lambda_cf(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_cf);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_cf: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 184;
        if (!(context__.contains_r("lambda_cf_male")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_cf_male missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_cf_male");
        pos__ = 0U;
        validate_non_negative_index("lambda_cf_male", "((ng - 1) * (1 - scfmale_isfixed))", ((ng - 1) * (1 - scfmale_isfixed)));
        context__.validate_dims("parameter initialization", "lambda_cf_male", "vector_d", context__.to_vec(((ng - 1) * (1 - scfmale_isfixed))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_cf_male(((ng - 1) * (1 - scfmale_isfixed)));
        size_t lambda_cf_male_j_1_max__ = ((ng - 1) * (1 - scfmale_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_male_j_1_max__; ++j_1__) {
            lambda_cf_male(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_cf_male);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_cf_male: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 185;
        if (!(context__.contains_r("lambda_inc")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_inc missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_inc");
        pos__ = 0U;
        validate_non_negative_index("lambda_inc", "(smooth_inc * (1 - sinc_isfixed))", (smooth_inc * (1 - sinc_isfixed)));
        context__.validate_dims("parameter initialization", "lambda_inc", "vector_d", context__.to_vec((smooth_inc * (1 - sinc_isfixed))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_inc((smooth_inc * (1 - sinc_isfixed)));
        size_t lambda_inc_j_1_max__ = (smooth_inc * (1 - sinc_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_inc_j_1_max__; ++j_1__) {
            lambda_inc(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_inc);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_inc: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 186;
        if (!(context__.contains_r("lambda_rem")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_rem missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_rem");
        pos__ = 0U;
        validate_non_negative_index("lambda_rem", "((remission * smooth_rem) * (1 - srem_isfixed))", ((remission * smooth_rem) * (1 - srem_isfixed)));
        context__.validate_dims("parameter initialization", "lambda_rem", "vector_d", context__.to_vec(((remission * smooth_rem) * (1 - srem_isfixed))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_rem(((remission * smooth_rem) * (1 - srem_isfixed)));
        size_t lambda_rem_j_1_max__ = ((remission * smooth_rem) * (1 - srem_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_rem_j_1_max__; ++j_1__) {
            lambda_rem(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_rem);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_rem: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 187;
        if (!(context__.contains_r("prevzero")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable prevzero missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("prevzero");
        pos__ = 0U;
        validate_non_negative_index("prevzero", "(narea * prev_zero)", (narea * prev_zero));
        validate_non_negative_index("prevzero", "ng", ng);
        context__.validate_dims("parameter initialization", "prevzero", "double", context__.to_vec((narea * prev_zero),ng));
        std::vector<std::vector<double> > prevzero((narea * prev_zero), std::vector<double>(ng, double(0)));
        size_t prevzero_k_0_max__ = (narea * prev_zero);
        size_t prevzero_k_1_max__ = ng;
        for (size_t k_1__ = 0; k_1__ < prevzero_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < prevzero_k_0_max__; ++k_0__) {
                prevzero[k_0__][k_1__] = vals_r__[pos__++];
            }
        }
        size_t prevzero_i_0_max__ = (narea * prev_zero);
        size_t prevzero_i_1_max__ = ng;
        for (size_t i_0__ = 0; i_0__ < prevzero_i_0_max__; ++i_0__) {
            for (size_t i_1__ = 0; i_1__ < prevzero_i_1_max__; ++i_1__) {
                try {
                    writer__.scalar_lub_unconstrain(0, 1, prevzero[i_0__][i_1__]);
                } catch (const std::exception& e) {
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable prevzero: ") + e.what()), current_statement_begin__, prog_reader__());
                }
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 163;
            std::vector<std::vector<std::vector<local_scalar_t__> > > inc_par;
            size_t inc_par_d_0_max__ = (nage * (1 - smooth_inc));
            size_t inc_par_d_1_max__ = narea;
            size_t inc_par_d_2_max__ = ng;
            inc_par.resize(inc_par_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < inc_par_d_0_max__; ++d_0__) {
                inc_par[d_0__].resize(inc_par_d_1_max__);
                for (size_t d_1__ = 0; d_1__ < inc_par_d_1_max__; ++d_1__) {
                    inc_par[d_0__][d_1__].reserve(inc_par_d_2_max__);
                    for (size_t d_2__ = 0; d_2__ < inc_par_d_2_max__; ++d_2__) {
                        if (jacobian__)
                            inc_par[d_0__][d_1__].push_back(in__.scalar_lb_constrain(0, lp__));
                        else
                            inc_par[d_0__][d_1__].push_back(in__.scalar_lb_constrain(0));
                    }
                }
            }
            current_statement_begin__ = 164;
            std::vector<std::vector<local_scalar_t__> > rem_par;
            size_t rem_par_d_0_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
            size_t rem_par_d_1_max__ = ng;
            rem_par.resize(rem_par_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rem_par_d_0_max__; ++d_0__) {
                rem_par[d_0__].reserve(rem_par_d_1_max__);
                for (size_t d_1__ = 0; d_1__ < rem_par_d_1_max__; ++d_1__) {
                    if (jacobian__)
                        rem_par[d_0__].push_back(in__.scalar_lb_constrain(0, lp__));
                    else
                        rem_par[d_0__].push_back(in__.scalar_lb_constrain(0));
                }
            }
            current_statement_begin__ = 167;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> barea;
            (void) barea;  // dummy to suppress unused var warning
            if (jacobian__)
                barea = in__.matrix_constrain(((K - 2) * (1 - const_cf)), ((narea * (1 - common)) + (1 * common)), lp__);
            else
                barea = in__.matrix_constrain(((K - 2) * (1 - const_cf)), ((narea * (1 - common)) + (1 * common)));
            current_statement_begin__ = 168;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> barea_slope;
            (void) barea_slope;  // dummy to suppress unused var warning
            if (jacobian__)
                barea_slope = in__.matrix_constrain(((1 - interceptonly) * (1 - const_cf)), ((narea * (1 - common)) + (1 * common)), lp__);
            else
                barea_slope = in__.matrix_constrain(((1 - interceptonly) * (1 - const_cf)), ((narea * (1 - common)) + (1 * common)));
            current_statement_begin__ = 169;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> barea_inter;
            (void) barea_inter;  // dummy to suppress unused var warning
            if (jacobian__)
                barea_inter = in__.matrix_constrain(1, (narea * (1 - common)), lp__);
            else
                barea_inter = in__.matrix_constrain(1, (narea * (1 - common)));
            current_statement_begin__ = 171;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> bmale;
            (void) bmale;  // dummy to suppress unused var warning
            if (jacobian__)
                bmale = in__.vector_constrain((K * (ng - 1)), lp__);
            else
                bmale = in__.vector_constrain((K * (ng - 1)));
            current_statement_begin__ = 174;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lcfbase;
            (void) lcfbase;  // dummy to suppress unused var warning
            if (jacobian__)
                lcfbase = in__.vector_constrain((((narea * (1 - common)) + (1 * common)) * increasing), lp__);
            else
                lcfbase = in__.vector_constrain((((narea * (1 - common)) + (1 * common)) * increasing));
            current_statement_begin__ = 176;
            std::vector<std::vector<std::vector<local_scalar_t__> > > beta_inc;
            size_t beta_inc_d_0_max__ = (K * smooth_inc);
            size_t beta_inc_d_1_max__ = narea;
            size_t beta_inc_d_2_max__ = ng;
            beta_inc.resize(beta_inc_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < beta_inc_d_0_max__; ++d_0__) {
                beta_inc[d_0__].resize(beta_inc_d_1_max__);
                for (size_t d_1__ = 0; d_1__ < beta_inc_d_1_max__; ++d_1__) {
                    beta_inc[d_0__][d_1__].reserve(beta_inc_d_2_max__);
                    for (size_t d_2__ = 0; d_2__ < beta_inc_d_2_max__; ++d_2__) {
                        if (jacobian__)
                            beta_inc[d_0__][d_1__].push_back(in__.scalar_constrain(lp__));
                        else
                            beta_inc[d_0__][d_1__].push_back(in__.scalar_constrain());
                    }
                }
            }
            current_statement_begin__ = 177;
            std::vector<std::vector<std::vector<local_scalar_t__> > > beta_rem;
            size_t beta_rem_d_0_max__ = (K * smooth_rem);
            size_t beta_rem_d_1_max__ = narea;
            size_t beta_rem_d_2_max__ = ng;
            beta_rem.resize(beta_rem_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < beta_rem_d_0_max__; ++d_0__) {
                beta_rem[d_0__].resize(beta_rem_d_1_max__);
                for (size_t d_1__ = 0; d_1__ < beta_rem_d_1_max__; ++d_1__) {
                    beta_rem[d_0__][d_1__].reserve(beta_rem_d_2_max__);
                    for (size_t d_2__ = 0; d_2__ < beta_rem_d_2_max__; ++d_2__) {
                        if (jacobian__)
                            beta_rem[d_0__][d_1__].push_back(in__.scalar_constrain(lp__));
                        else
                            beta_rem[d_0__][d_1__].push_back(in__.scalar_constrain());
                    }
                }
            }
            current_statement_begin__ = 179;
            local_scalar_t__ mean_inter;
            (void) mean_inter;  // dummy to suppress unused var warning
            if (jacobian__)
                mean_inter = in__.scalar_constrain(lp__);
            else
                mean_inter = in__.scalar_constrain();
            current_statement_begin__ = 180;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sd_inter;
            (void) sd_inter;  // dummy to suppress unused var warning
            if (jacobian__)
                sd_inter = in__.vector_lb_constrain(0, (1 - sd_int_isfixed), lp__);
            else
                sd_inter = in__.vector_lb_constrain(0, (1 - sd_int_isfixed));
            current_statement_begin__ = 181;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mean_slope;
            (void) mean_slope;  // dummy to suppress unused var warning
            if (jacobian__)
                mean_slope = in__.vector_constrain((1 - const_cf), lp__);
            else
                mean_slope = in__.vector_constrain((1 - const_cf));
            current_statement_begin__ = 182;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sd_slope;
            (void) sd_slope;  // dummy to suppress unused var warning
            if (jacobian__)
                sd_slope = in__.vector_lb_constrain(0, ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed)), lp__);
            else
                sd_slope = in__.vector_lb_constrain(0, ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed)));
            current_statement_begin__ = 183;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_cf;
            (void) lambda_cf;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_cf = in__.vector_lb_constrain(0, ((1 - const_cf) * (1 - scf_isfixed)), lp__);
            else
                lambda_cf = in__.vector_lb_constrain(0, ((1 - const_cf) * (1 - scf_isfixed)));
            current_statement_begin__ = 184;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_cf_male;
            (void) lambda_cf_male;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_cf_male = in__.vector_lb_constrain(0, ((ng - 1) * (1 - scfmale_isfixed)), lp__);
            else
                lambda_cf_male = in__.vector_lb_constrain(0, ((ng - 1) * (1 - scfmale_isfixed)));
            current_statement_begin__ = 185;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_inc;
            (void) lambda_inc;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_inc = in__.vector_lb_constrain(0, (smooth_inc * (1 - sinc_isfixed)), lp__);
            else
                lambda_inc = in__.vector_lb_constrain(0, (smooth_inc * (1 - sinc_isfixed)));
            current_statement_begin__ = 186;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_rem;
            (void) lambda_rem;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_rem = in__.vector_lb_constrain(0, ((remission * smooth_rem) * (1 - srem_isfixed)), lp__);
            else
                lambda_rem = in__.vector_lb_constrain(0, ((remission * smooth_rem) * (1 - srem_isfixed)));
            current_statement_begin__ = 187;
            std::vector<std::vector<local_scalar_t__> > prevzero;
            size_t prevzero_d_0_max__ = (narea * prev_zero);
            size_t prevzero_d_1_max__ = ng;
            prevzero.resize(prevzero_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < prevzero_d_0_max__; ++d_0__) {
                prevzero[d_0__].reserve(prevzero_d_1_max__);
                for (size_t d_1__ = 0; d_1__ < prevzero_d_1_max__; ++d_1__) {
                    if (jacobian__)
                        prevzero[d_0__].push_back(in__.scalar_lub_constrain(0, 1, lp__));
                    else
                        prevzero[d_0__].push_back(in__.scalar_lub_constrain(0, 1));
                }
            }
            // transformed parameters
            current_statement_begin__ = 192;
            validate_non_negative_index("inc", "nage", nage);
            validate_non_negative_index("inc", "narea", narea);
            validate_non_negative_index("inc", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > inc(nage, std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(inc, DUMMY_VAR__);
            stan::math::fill(inc, DUMMY_VAR__);
            current_statement_begin__ = 193;
            validate_non_negative_index("cf", "nage", nage);
            validate_non_negative_index("cf", "narea", narea);
            validate_non_negative_index("cf", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > cf(nage, std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(cf, DUMMY_VAR__);
            stan::math::fill(cf, DUMMY_VAR__);
            current_statement_begin__ = 194;
            validate_non_negative_index("dcf", "(nage * increasing)", (nage * increasing));
            validate_non_negative_index("dcf", "narea", narea);
            validate_non_negative_index("dcf", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > dcf((nage * increasing), std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(dcf, DUMMY_VAR__);
            stan::math::fill(dcf, DUMMY_VAR__);
            current_statement_begin__ = 195;
            validate_non_negative_index("inc_prob", "nage", nage);
            validate_non_negative_index("inc_prob", "narea", narea);
            validate_non_negative_index("inc_prob", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > inc_prob(nage, std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(inc_prob, DUMMY_VAR__);
            stan::math::fill(inc_prob, DUMMY_VAR__);
            current_statement_begin__ = 196;
            validate_non_negative_index("prev_prob", "nage", nage);
            validate_non_negative_index("prev_prob", "narea", narea);
            validate_non_negative_index("prev_prob", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > prev_prob(nage, std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(prev_prob, DUMMY_VAR__);
            stan::math::fill(prev_prob, DUMMY_VAR__);
            current_statement_begin__ = 197;
            validate_non_negative_index("mort_prob", "nage", nage);
            validate_non_negative_index("mort_prob", "narea", narea);
            validate_non_negative_index("mort_prob", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > mort_prob(nage, std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(mort_prob, DUMMY_VAR__);
            stan::math::fill(mort_prob, DUMMY_VAR__);
            current_statement_begin__ = 198;
            validate_non_negative_index("rem", "nage", nage);
            validate_non_negative_index("rem", "narea", narea);
            validate_non_negative_index("rem", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > rem(nage, std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(rem, DUMMY_VAR__);
            stan::math::fill(rem, DUMMY_VAR__);
            current_statement_begin__ = 199;
            validate_non_negative_index("rem_prob", "(nage * remission)", (nage * remission));
            validate_non_negative_index("rem_prob", "narea", narea);
            validate_non_negative_index("rem_prob", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > rem_prob((nage * remission), std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(rem_prob, DUMMY_VAR__);
            stan::math::fill(rem_prob, DUMMY_VAR__);
            current_statement_begin__ = 200;
            validate_non_negative_index("cf_prob", "nage", nage);
            validate_non_negative_index("cf_prob", "narea", narea);
            validate_non_negative_index("cf_prob", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > cf_prob(nage, std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(cf_prob, DUMMY_VAR__);
            stan::math::fill(cf_prob, DUMMY_VAR__);
            current_statement_begin__ = 201;
            validate_non_negative_index("state_probs", "3", 3);
            validate_non_negative_index("state_probs", "(nage + 1)", (nage + 1));
            validate_non_negative_index("state_probs", "narea", narea);
            validate_non_negative_index("state_probs", "ng", ng);
            std::vector<std::vector<std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > > > state_probs((nage + 1), std::vector<std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > >(narea, std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >(ng, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(3))));
            stan::math::initialize(state_probs, DUMMY_VAR__);
            stan::math::fill(state_probs, DUMMY_VAR__);
            current_statement_begin__ = 202;
            validate_non_negative_index("tmp", "3", 3);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> tmp(3);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            current_statement_begin__ = 203;
            validate_non_negative_index("P", "3", 3);
            validate_non_negative_index("P", "3", 3);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
            stan::math::initialize(P, DUMMY_VAR__);
            stan::math::fill(P, DUMMY_VAR__);
            current_statement_begin__ = 204;
            local_scalar_t__ sdint_use;
            (void) sdint_use;  // dummy to suppress unused var warning
            stan::math::initialize(sdint_use, DUMMY_VAR__);
            stan::math::fill(sdint_use, DUMMY_VAR__);
            current_statement_begin__ = 205;
            local_scalar_t__ sdslope_use;
            (void) sdslope_use;  // dummy to suppress unused var warning
            stan::math::initialize(sdslope_use, DUMMY_VAR__);
            stan::math::fill(sdslope_use, DUMMY_VAR__);
            current_statement_begin__ = 207;
            validate_non_negative_index("bareat", "K", K);
            validate_non_negative_index("bareat", "narea", narea);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> bareat(K, narea);
            stan::math::initialize(bareat, DUMMY_VAR__);
            stan::math::fill(bareat, DUMMY_VAR__);
            current_statement_begin__ = 208;
            validate_non_negative_index("beta", "K", K);
            validate_non_negative_index("beta", "narea", narea);
            validate_non_negative_index("beta", "ng", ng);
            std::vector<std::vector<std::vector<local_scalar_t__> > > beta(K, std::vector<std::vector<local_scalar_t__> >(narea, std::vector<local_scalar_t__>(ng, local_scalar_t__(0))));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 209;
            local_scalar_t__ lambda_cf_use;
            (void) lambda_cf_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_cf_use, DUMMY_VAR__);
            stan::math::fill(lambda_cf_use, DUMMY_VAR__);
            current_statement_begin__ = 210;
            local_scalar_t__ lambda_cf_male_use;
            (void) lambda_cf_male_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_cf_male_use, DUMMY_VAR__);
            stan::math::fill(lambda_cf_male_use, DUMMY_VAR__);
            current_statement_begin__ = 211;
            local_scalar_t__ lambda_inc_use;
            (void) lambda_inc_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_inc_use, DUMMY_VAR__);
            stan::math::fill(lambda_inc_use, DUMMY_VAR__);
            current_statement_begin__ = 212;
            local_scalar_t__ lambda_rem_use;
            (void) lambda_rem_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_rem_use, DUMMY_VAR__);
            stan::math::fill(lambda_rem_use, DUMMY_VAR__);
            current_statement_begin__ = 213;
            validate_non_negative_index("lcfbase_use", "(narea * increasing)", (narea * increasing));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lcfbase_use((narea * increasing));
            stan::math::initialize(lcfbase_use, DUMMY_VAR__);
            stan::math::fill(lcfbase_use, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 215;
            if (as_bool(sd_int_isfixed)) {
                current_statement_begin__ = 215;
                stan::math::assign(sdint_use, sd_int_fixed);
            } else {
                current_statement_begin__ = 215;
                stan::math::assign(sdint_use, get_base1(sd_inter, 1, "sd_inter", 1));
            }
            current_statement_begin__ = 216;
            if (as_bool((primitive_value((primitive_value((primitive_value(sd_slope_isfixed) || primitive_value(const_cf))) || primitive_value(interceptonly))) || primitive_value(increasing)))) {
                current_statement_begin__ = 216;
                stan::math::assign(sdslope_use, sd_slope_fixed);
            } else {
                current_statement_begin__ = 216;
                stan::math::assign(sdslope_use, get_base1(sd_slope, 1, "sd_slope", 1));
            }
            current_statement_begin__ = 217;
            if (as_bool((primitive_value(scf_isfixed) || primitive_value(const_cf)))) {
                current_statement_begin__ = 217;
                stan::math::assign(lambda_cf_use, lambda_cf_fixed);
            } else {
                current_statement_begin__ = 217;
                stan::math::assign(lambda_cf_use, get_base1(lambda_cf, 1, "lambda_cf", 1));
            }
            current_statement_begin__ = 218;
            if (as_bool((primitive_value(scfmale_isfixed) || primitive_value(logical_eq(ng, 1))))) {
                current_statement_begin__ = 218;
                stan::math::assign(lambda_cf_male_use, lambda_cf_male_fixed);
            } else {
                current_statement_begin__ = 218;
                stan::math::assign(lambda_cf_male_use, get_base1(lambda_cf_male, 1, "lambda_cf_male", 1));
            }
            current_statement_begin__ = 219;
            if (as_bool((primitive_value(sinc_isfixed) || primitive_value(logical_negation(smooth_inc))))) {
                current_statement_begin__ = 219;
                stan::math::assign(lambda_inc_use, lambda_inc_fixed);
            } else {
                current_statement_begin__ = 219;
                stan::math::assign(lambda_inc_use, get_base1(lambda_inc, 1, "lambda_inc", 1));
            }
            current_statement_begin__ = 220;
            if (as_bool((primitive_value(srem_isfixed) || primitive_value(logical_negation(smooth_rem))))) {
                current_statement_begin__ = 220;
                stan::math::assign(lambda_rem_use, lambda_rem_fixed);
            } else {
                current_statement_begin__ = 220;
                stan::math::assign(lambda_rem_use, get_base1(lambda_rem, 1, "lambda_rem", 1));
            }
            current_statement_begin__ = 222;
            for (int j = 1; j <= narea; ++j) {
                current_statement_begin__ = 223;
                if (as_bool(common)) {
                    current_statement_begin__ = 224;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 224;
                        stan::model::assign(lcfbase_use, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    get_base1(lcfbase, 1, "lcfbase", 1), 
                                    "assigning variable lcfbase_use");
                    }
                    current_statement_begin__ = 225;
                    if (as_bool(const_cf)) {
                        current_statement_begin__ = 226;
                        for (int i = 1; i <= (K - 1); ++i) {
                            current_statement_begin__ = 227;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        0, 
                                        "assigning variable bareat");
                        }
                    } else {
                        current_statement_begin__ = 230;
                        for (int i = 1; i <= (K - 2); ++i) {
                            current_statement_begin__ = 231;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(barea, i, 1, "barea", 1) * lambda_cf_use), 
                                        "assigning variable bareat");
                        }
                        current_statement_begin__ = 233;
                        if (as_bool(increasing)) {
                            current_statement_begin__ = 234;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(barea_slope, 1, 1, "barea_slope", 1) * lambda_cf_use), 
                                        "assigning variable bareat");
                        } else {
                            current_statement_begin__ = 236;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        get_base1(mean_slope, 1, "mean_slope", 1), 
                                        "assigning variable bareat");
                        }
                    }
                    current_statement_begin__ = 239;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 240;
                        stan::model::assign(bareat, 
                                    stan::model::cons_list(stan::model::index_uni(K), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    get_base1(mean_slope, 1, "mean_slope", 1), 
                                    "assigning variable bareat");
                    } else {
                        current_statement_begin__ = 242;
                        stan::model::assign(bareat, 
                                    stan::model::cons_list(stan::model::index_uni(K), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    mean_inter, 
                                    "assigning variable bareat");
                    }
                } else {
                    current_statement_begin__ = 247;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 247;
                        stan::model::assign(lcfbase_use, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    get_base1(lcfbase, j, "lcfbase", 1), 
                                    "assigning variable lcfbase_use");
                    }
                    current_statement_begin__ = 248;
                    if (as_bool(const_cf)) {
                        current_statement_begin__ = 249;
                        for (int i = 1; i <= (K - 1); ++i) {
                            current_statement_begin__ = 250;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        0, 
                                        "assigning variable bareat");
                        }
                    } else {
                        current_statement_begin__ = 253;
                        for (int i = 1; i <= (K - 2); ++i) {
                            current_statement_begin__ = 254;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(barea, i, j, "barea", 1) * lambda_cf_use), 
                                        "assigning variable bareat");
                        }
                        current_statement_begin__ = 256;
                        if (as_bool(interceptonly)) {
                            current_statement_begin__ = 257;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        get_base1(mean_slope, 1, "mean_slope", 1), 
                                        "assigning variable bareat");
                        } else if (as_bool(increasing)) {
                            current_statement_begin__ = 259;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(barea_slope, 1, j, "barea_slope", 1) * lambda_cf_use), 
                                        "assigning variable bareat");
                        } else {
                            current_statement_begin__ = 261;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(mean_slope, 1, "mean_slope", 1) + (get_base1(barea_slope, 1, j, "barea_slope", 1) * sdslope_use)), 
                                        "assigning variable bareat");
                        }
                    }
                    current_statement_begin__ = 264;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 265;
                        stan::model::assign(bareat, 
                                    stan::model::cons_list(stan::model::index_uni(K), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    get_base1(mean_slope, 1, "mean_slope", 1), 
                                    "assigning variable bareat");
                    } else {
                        current_statement_begin__ = 267;
                        stan::model::assign(bareat, 
                                    stan::model::cons_list(stan::model::index_uni(K), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    (mean_inter + (get_base1(barea_inter, 1, j, "barea_inter", 1) * sdint_use)), 
                                    "assigning variable bareat");
                    }
                }
            }
            current_statement_begin__ = 273;
            for (int g = 1; g <= ng; ++g) {
                current_statement_begin__ = 274;
                for (int j = 1; j <= narea; ++j) {
                    current_statement_begin__ = 275;
                    for (int a = 1; a <= nage; ++a) {
                        current_statement_begin__ = 276;
                        if (as_bool(smooth_inc)) {
                            current_statement_begin__ = 277;
                            stan::model::assign(inc, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::math::exp(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), to_vector(stan::model::rvalue(beta_inc, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "beta_inc")))), 
                                        "assigning variable inc");
                        } else {
                            current_statement_begin__ = 279;
                            stan::model::assign(inc, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(get_base1(inc_par, a, "inc_par", 1), j, "inc_par", 2), g, "inc_par", 3), 
                                        "assigning variable inc");
                        }
                    }
                    current_statement_begin__ = 282;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 283;
                        if (as_bool(logical_gt(ng, 1))) {
                            current_statement_begin__ = 284;
                            stan::model::assign(beta, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(bareat, k, j, "bareat", 1) + (get_base1(bmale, k, "bmale", 1) * (g - 1))), 
                                        "assigning variable beta");
                        } else {
                            current_statement_begin__ = 286;
                            stan::model::assign(beta, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        get_base1(bareat, k, j, "bareat", 1), 
                                        "assigning variable beta");
                        }
                    }
                    current_statement_begin__ = 291;
                    if (as_bool((primitive_value(logical_gt(get_base1(get_base1(get_base1(prev_denom, 1, "prev_denom", 1), j, "prev_denom", 2), g, "prev_denom", 3), 0)) && primitive_value((primitive_value(logical_gt(get_base1(get_base1(get_base1(prev_num, 1, "prev_num", 1), j, "prev_num", 2), g, "prev_num", 3), 0)) || primitive_value(prev_zero)))))) {
                        current_statement_begin__ = 292;
                        stan::model::assign(prev_prob, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    get_base1(get_base1(prevzero, j, "prevzero", 1), g, "prevzero", 2), 
                                    "assigning variable prev_prob");
                    } else {
                        current_statement_begin__ = 293;
                        stan::model::assign(prev_prob, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    0, 
                                    "assigning variable prev_prob");
                    }
                    current_statement_begin__ = 294;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())))), 
                                1, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 295;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())))), 
                                0, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 296;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())))), 
                                0, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 298;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 300;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 301;
                            stan::model::assign(dcf, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::math::exp(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), to_vector(stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "beta")))), 
                                        "assigning variable dcf");
                        }
                        current_statement_begin__ = 304;
                        for (int a = 1; a <= (eqage - 1); ++a) {
                            current_statement_begin__ = 305;
                            stan::model::assign(cf, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::math::exp(get_base1(lcfbase_use, j, "lcfbase_use", 1)), 
                                        "assigning variable cf");
                        }
                        current_statement_begin__ = 307;
                        for (int a = eqage; a <= nage; ++a) {
                            current_statement_begin__ = 308;
                            stan::model::assign(cf, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(cf, (a - 1), "cf", 1), j, "cf", 2), g, "cf", 3) + get_base1(get_base1(get_base1(dcf, a, "dcf", 1), j, "dcf", 2), g, "dcf", 3)), 
                                        "assigning variable cf");
                        }
                    } else {
                        current_statement_begin__ = 315;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 316;
                            stan::model::assign(cf, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::math::exp(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), to_vector(stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "beta")))), 
                                        "assigning variable cf");
                        }
                    }
                    current_statement_begin__ = 320;
                    if (as_bool(remission)) {
                        current_statement_begin__ = 321;
                        if (as_bool(smooth_rem)) {
                            current_statement_begin__ = 322;
                            for (int a = 1; a <= nage; ++a) {
                                current_statement_begin__ = 323;
                                stan::model::assign(rem, 
                                            stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                            stan::math::exp(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), to_vector(stan::model::rvalue(beta_rem, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "beta_rem")))), 
                                            "assigning variable rem");
                            }
                        } else if (as_bool(const_rem)) {
                            current_statement_begin__ = 327;
                            for (int a = 1; a <= nage; ++a) {
                                current_statement_begin__ = 328;
                                stan::model::assign(rem, 
                                            stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                            get_base1(get_base1(rem_par, 1, "rem_par", 1), g, "rem_par", 2), 
                                            "assigning variable rem");
                            }
                        } else {
                            current_statement_begin__ = 330;
                            stan::model::assign(rem, 
                                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::model::rvalue(rem_par, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "rem_par"), 
                                        "assigning variable rem");
                        }
                    } else {
                        current_statement_begin__ = 331;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 331;
                            stan::model::assign(rem, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        0, 
                                        "assigning variable rem");
                        }
                    }
                    current_statement_begin__ = 332;
                    for (int a = 1; a <= nage; ++a) {
                        current_statement_begin__ = 333;
                        stan::math::assign(P, trans_probs(get_base1(get_base1(get_base1(inc, a, "inc", 1), j, "inc", 2), g, "inc", 3), get_base1(get_base1(get_base1(cf, a, "cf", 1), j, "cf", 2), g, "cf", 3), get_base1(get_base1(get_base1(rem, a, "rem", 1), j, "rem", 2), g, "rem", 3), pstream__));
                        current_statement_begin__ = 334;
                        stan::model::assign(inc_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    bound_prob((get_base1(P, 1, 2, "P", 1) + get_base1(P, 1, 3, "P", 1)), pstream__), 
                                    "assigning variable inc_prob");
                        current_statement_begin__ = 335;
                        if (as_bool(remission)) {
                            current_statement_begin__ = 336;
                            stan::model::assign(rem_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        get_base1(P, 2, 1, "P", 1), 
                                        "assigning variable rem_prob");
                        }
                        current_statement_begin__ = 337;
                        if (as_bool(logical_gt(a, 1))) {
                            current_statement_begin__ = 338;
                            stan::model::assign(prev_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), j, "state_probs", 2), g, "state_probs", 3), 2, "state_probs", 4) / (get_base1(get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), j, "state_probs", 2), g, "state_probs", 3), 1, "state_probs", 4) + get_base1(get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), j, "state_probs", 2), g, "state_probs", 3), 2, "state_probs", 4))), 
                                        "assigning variable prev_prob");
                        }
                        current_statement_begin__ = 339;
                        stan::math::assign(tmp, multiply(stan::model::rvalue(state_probs, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), "state_probs"), P));
                        current_statement_begin__ = 340;
                        stan::model::assign(state_probs, 
                                    stan::model::cons_list(stan::model::index_uni((a + 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), 
                                    tmp, 
                                    "assigning variable state_probs");
                        current_statement_begin__ = 341;
                        stan::model::assign(cf_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    bound_prob(get_base1(P, 2, 3, "P", 1), pstream__), 
                                    "assigning variable cf_prob");
                        current_statement_begin__ = 342;
                        stan::model::assign(mort_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    ((get_base1(P, 1, 3, "P", 1) * (1 - get_base1(get_base1(get_base1(prev_prob, a, "prev_prob", 1), j, "prev_prob", 2), g, "prev_prob", 3))) + (get_base1(P, 2, 3, "P", 1) * get_base1(get_base1(get_base1(prev_prob, a, "prev_prob", 1), j, "prev_prob", 2), g, "prev_prob", 3))), 
                                    "assigning variable mort_prob");
                        current_statement_begin__ = 344;
                        stan::model::assign(mort_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    bound_prob(get_base1(get_base1(get_base1(mort_prob, a, "mort_prob", 1), j, "mort_prob", 2), g, "mort_prob", 3), pstream__), 
                                    "assigning variable mort_prob");
                        current_statement_begin__ = 345;
                        stan::model::assign(mort_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    bound_prob(get_base1(get_base1(get_base1(mort_prob, a, "mort_prob", 1), j, "mort_prob", 2), g, "mort_prob", 3), pstream__), 
                                    "assigning variable mort_prob");
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 192;
            size_t inc_k_0_max__ = nage;
            size_t inc_k_1_max__ = narea;
            size_t inc_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < inc_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < inc_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < inc_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(inc[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: inc" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable inc: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t inc_i_0_max__ = nage;
            size_t inc_i_1_max__ = narea;
            size_t inc_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < inc_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < inc_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < inc_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "inc[i_0__][i_1__][i_2__]", inc[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 193;
            size_t cf_k_0_max__ = nage;
            size_t cf_k_1_max__ = narea;
            size_t cf_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < cf_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < cf_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < cf_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(cf[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: cf" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable cf: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t cf_i_0_max__ = nage;
            size_t cf_i_1_max__ = narea;
            size_t cf_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < cf_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < cf_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < cf_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "cf[i_0__][i_1__][i_2__]", cf[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 194;
            size_t dcf_k_0_max__ = (nage * increasing);
            size_t dcf_k_1_max__ = narea;
            size_t dcf_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < dcf_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < dcf_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < dcf_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(dcf[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: dcf" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable dcf: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t dcf_i_0_max__ = (nage * increasing);
            size_t dcf_i_1_max__ = narea;
            size_t dcf_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < dcf_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < dcf_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < dcf_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "dcf[i_0__][i_1__][i_2__]", dcf[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 195;
            size_t inc_prob_k_0_max__ = nage;
            size_t inc_prob_k_1_max__ = narea;
            size_t inc_prob_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < inc_prob_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < inc_prob_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < inc_prob_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(inc_prob[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: inc_prob" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable inc_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t inc_prob_i_0_max__ = nage;
            size_t inc_prob_i_1_max__ = narea;
            size_t inc_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < inc_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < inc_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < inc_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "inc_prob[i_0__][i_1__][i_2__]", inc_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 196;
            size_t prev_prob_k_0_max__ = nage;
            size_t prev_prob_k_1_max__ = narea;
            size_t prev_prob_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < prev_prob_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < prev_prob_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < prev_prob_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(prev_prob[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: prev_prob" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable prev_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t prev_prob_i_0_max__ = nage;
            size_t prev_prob_i_1_max__ = narea;
            size_t prev_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < prev_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < prev_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < prev_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "prev_prob[i_0__][i_1__][i_2__]", prev_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 197;
            size_t mort_prob_k_0_max__ = nage;
            size_t mort_prob_k_1_max__ = narea;
            size_t mort_prob_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < mort_prob_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < mort_prob_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < mort_prob_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(mort_prob[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: mort_prob" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mort_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t mort_prob_i_0_max__ = nage;
            size_t mort_prob_i_1_max__ = narea;
            size_t mort_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < mort_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < mort_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < mort_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "mort_prob[i_0__][i_1__][i_2__]", mort_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 198;
            size_t rem_k_0_max__ = nage;
            size_t rem_k_1_max__ = narea;
            size_t rem_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < rem_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < rem_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < rem_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(rem[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: rem" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rem: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t rem_i_0_max__ = nage;
            size_t rem_i_1_max__ = narea;
            size_t rem_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < rem_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rem_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < rem_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "rem[i_0__][i_1__][i_2__]", rem[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 199;
            size_t rem_prob_k_0_max__ = (nage * remission);
            size_t rem_prob_k_1_max__ = narea;
            size_t rem_prob_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < rem_prob_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < rem_prob_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < rem_prob_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(rem_prob[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: rem_prob" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rem_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t rem_prob_i_0_max__ = (nage * remission);
            size_t rem_prob_i_1_max__ = narea;
            size_t rem_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < rem_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rem_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < rem_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "rem_prob[i_0__][i_1__][i_2__]", rem_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 200;
            size_t cf_prob_k_0_max__ = nage;
            size_t cf_prob_k_1_max__ = narea;
            size_t cf_prob_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < cf_prob_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < cf_prob_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < cf_prob_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(cf_prob[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: cf_prob" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable cf_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t cf_prob_i_0_max__ = nage;
            size_t cf_prob_i_1_max__ = narea;
            size_t cf_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < cf_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < cf_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < cf_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "cf_prob[i_0__][i_1__][i_2__]", cf_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 201;
            size_t state_probs_k_0_max__ = (nage + 1);
            size_t state_probs_k_1_max__ = narea;
            size_t state_probs_k_2_max__ = ng;
            size_t state_probs_j_1_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < state_probs_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < state_probs_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < state_probs_k_2_max__; ++k_2__) {
                        for (size_t j_1__ = 0; j_1__ < state_probs_j_1_max__; ++j_1__) {
                            if (stan::math::is_uninitialized(state_probs[k_0__][k_1__][k_2__](j_1__))) {
                                std::stringstream msg__;
                                msg__ << "Undefined transformed parameter: state_probs" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]" << "(" << j_1__ << ")";
                                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable state_probs: ") + msg__.str()), current_statement_begin__, prog_reader__());
                            }
                        }
                    }
                }
            }
            current_statement_begin__ = 202;
            size_t tmp_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tmp(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tmp" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tmp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 203;
            size_t P_j_1_max__ = 3;
            size_t P_j_2_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < P_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < P_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(P(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: P" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable P: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 204;
            if (stan::math::is_uninitialized(sdint_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: sdint_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sdint_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "sdint_use", sdint_use, 0);
            current_statement_begin__ = 205;
            if (stan::math::is_uninitialized(sdslope_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: sdslope_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sdslope_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "sdslope_use", sdslope_use, 0);
            current_statement_begin__ = 207;
            size_t bareat_j_1_max__ = K;
            size_t bareat_j_2_max__ = narea;
            for (size_t j_1__ = 0; j_1__ < bareat_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < bareat_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(bareat(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: bareat" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable bareat: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 208;
            size_t beta_k_0_max__ = K;
            size_t beta_k_1_max__ = narea;
            size_t beta_k_2_max__ = ng;
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < beta_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < beta_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(beta[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: beta" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 209;
            if (stan::math::is_uninitialized(lambda_cf_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda_cf_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_cf_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "lambda_cf_use", lambda_cf_use, 0);
            current_statement_begin__ = 210;
            if (stan::math::is_uninitialized(lambda_cf_male_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda_cf_male_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_cf_male_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "lambda_cf_male_use", lambda_cf_male_use, 0);
            current_statement_begin__ = 211;
            if (stan::math::is_uninitialized(lambda_inc_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda_inc_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_inc_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "lambda_inc_use", lambda_inc_use, 0);
            current_statement_begin__ = 212;
            if (stan::math::is_uninitialized(lambda_rem_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda_rem_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_rem_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "lambda_rem_use", lambda_rem_use, 0);
            current_statement_begin__ = 213;
            size_t lcfbase_use_j_1_max__ = (narea * increasing);
            for (size_t j_1__ = 0; j_1__ < lcfbase_use_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lcfbase_use(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lcfbase_use" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lcfbase_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 352;
            lp_accum__.add(normal_log<propto__>(mean_inter, mipm, mips));
            current_statement_begin__ = 355;
            if (as_bool(logical_negation(const_cf))) {
                current_statement_begin__ = 356;
                lp_accum__.add(normal_log<propto__>(mean_slope, mism, miss));
                current_statement_begin__ = 357;
                if (as_bool(common)) {
                    current_statement_begin__ = 358;
                    for (int i = 1; i <= (K - 2); ++i) {
                        current_statement_begin__ = 359;
                        lp_accum__.add(normal_log<propto__>(get_base1(barea, i, 1, "barea", 1), 0, 1));
                    }
                    current_statement_begin__ = 361;
                    if (as_bool((primitive_value(logical_negation(interceptonly)) && primitive_value(logical_negation(const_cf))))) {
                        current_statement_begin__ = 362;
                        lp_accum__.add(normal_log<propto__>(get_base1(barea_slope, 1, 1, "barea_slope", 1), 0, 1));
                    }
                } else {
                    current_statement_begin__ = 365;
                    for (int j = 1; j <= narea; ++j) {
                        current_statement_begin__ = 366;
                        for (int i = 1; i <= (K - 2); ++i) {
                            current_statement_begin__ = 367;
                            lp_accum__.add(normal_log<propto__>(get_base1(barea, i, j, "barea", 1), 0, 1));
                        }
                        current_statement_begin__ = 369;
                        lp_accum__.add(normal_log<propto__>(get_base1(barea_inter, 1, j, "barea_inter", 1), 0, 1));
                        current_statement_begin__ = 370;
                        if (as_bool((primitive_value(logical_negation(interceptonly)) && primitive_value(logical_negation(const_cf))))) {
                            current_statement_begin__ = 371;
                            lp_accum__.add(normal_log<propto__>(get_base1(barea_slope, 1, j, "barea_slope", 1), 0, 1));
                        }
                    }
                }
            }
            current_statement_begin__ = 377;
            if (as_bool(smooth_inc)) {
                current_statement_begin__ = 381;
                for (int j = 1; j <= narea; ++j) {
                    current_statement_begin__ = 382;
                    for (int g = 1; g <= ng; ++g) {
                        current_statement_begin__ = 383;
                        for (int i = 1; i <= (K - 2); ++i) {
                            current_statement_begin__ = 384;
                            lp_accum__.add(normal_log<propto__>(get_base1(get_base1(get_base1(beta_inc, i, "beta_inc", 1), j, "beta_inc", 2), g, "beta_inc", 3), 0, lambda_inc_use));
                        }
                        current_statement_begin__ = 386;
                        for (int i = (K - 1); i <= K; ++i) {
                            current_statement_begin__ = 387;
                            lp_accum__.add(normal_log<propto__>(get_base1(get_base1(get_base1(beta_inc, i, "beta_inc", 1), j, "beta_inc", 2), g, "beta_inc", 3), 0, 100));
                        }
                    }
                }
            }
            current_statement_begin__ = 394;
            if (as_bool((primitive_value(increasing) && primitive_value(common)))) {
                current_statement_begin__ = 395;
                lp_accum__.add(normal_log<propto__>(get_base1(lcfbase, 1, "lcfbase", 1), 0, 100));
            }
            current_statement_begin__ = 397;
            for (int j = 1; j <= narea; ++j) {
                current_statement_begin__ = 398;
                for (int g = 1; g <= ng; ++g) {
                    current_statement_begin__ = 399;
                    lp_accum__.add(binomial_log<propto__>(stan::model::rvalue(mort_num, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "mort_num"), stan::model::rvalue(mort_denom, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "mort_denom"), stan::model::rvalue(mort_prob, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "mort_prob")));
                    current_statement_begin__ = 400;
                    lp_accum__.add(binomial_log<propto__>(stan::model::rvalue(inc_num, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "inc_num"), stan::model::rvalue(inc_denom, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "inc_denom"), stan::model::rvalue(inc_prob, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "inc_prob")));
                    current_statement_begin__ = 401;
                    lp_accum__.add(binomial_log<propto__>(stan::model::rvalue(prev_num, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "prev_num"), stan::model::rvalue(prev_denom, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "prev_denom"), stan::model::rvalue(prev_prob, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "prev_prob")));
                    current_statement_begin__ = 402;
                    if (as_bool(remission)) {
                        current_statement_begin__ = 403;
                        lp_accum__.add(binomial_log<propto__>(stan::model::rvalue(rem_num, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "rem_num"), stan::model::rvalue(rem_denom, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "rem_denom"), stan::model::rvalue(rem_prob, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "rem_prob")));
                    }
                }
                current_statement_begin__ = 406;
                if (as_bool((primitive_value(increasing) && primitive_value(logical_negation(common))))) {
                    current_statement_begin__ = 407;
                    lp_accum__.add(normal_log<propto__>(get_base1(lcfbase, j, "lcfbase", 1), mean_inter, sd_inter));
                }
            }
            current_statement_begin__ = 410;
            if (as_bool(remission)) {
                current_statement_begin__ = 411;
                if (as_bool(smooth_rem)) {
                    current_statement_begin__ = 412;
                    for (int j = 1; j <= narea; ++j) {
                        current_statement_begin__ = 413;
                        for (int g = 1; g <= ng; ++g) {
                            current_statement_begin__ = 414;
                            for (int i = 1; i <= (K - 2); ++i) {
                                current_statement_begin__ = 415;
                                lp_accum__.add(normal_log<propto__>(get_base1(get_base1(get_base1(beta_rem, i, "beta_rem", 1), j, "beta_rem", 2), g, "beta_rem", 3), 0, lambda_rem_use));
                            }
                            current_statement_begin__ = 417;
                            for (int i = (K - 1); i <= K; ++i) {
                                current_statement_begin__ = 418;
                                lp_accum__.add(normal_log<propto__>(get_base1(get_base1(get_base1(beta_rem, i, "beta_rem", 1), j, "beta_rem", 2), g, "beta_rem", 3), 0, 100));
                            }
                        }
                    }
                } else if (as_bool(const_rem)) {
                    current_statement_begin__ = 424;
                    for (int g = 1; g <= ng; ++g) {
                        current_statement_begin__ = 424;
                        lp_accum__.add(gamma_log<propto__>(get_base1(get_base1(rem_par, 1, "rem_par", 1), g, "rem_par", 2), get_base1(rem_prior, 1, "rem_prior", 1), get_base1(rem_prior, 2, "rem_prior", 1)));
                    }
                } else {
                    current_statement_begin__ = 426;
                    for (int g = 1; g <= ng; ++g) {
                        current_statement_begin__ = 427;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 428;
                            lp_accum__.add(gamma_log<propto__>(get_base1(get_base1(rem_par, a, "rem_par", 1), g, "rem_par", 2), get_base1(rem_prior, 1, "rem_prior", 1), get_base1(rem_prior, 2, "rem_prior", 1)));
                        }
                    }
                }
            }
            current_statement_begin__ = 435;
            if (as_bool((primitive_value(logical_negation(const_cf)) && primitive_value(logical_negation(scf_isfixed))))) {
                current_statement_begin__ = 436;
                lp_accum__.add(gamma_log<propto__>(lambda_cf, 2, get_base1(sprior, 2, "sprior", 1)));
            }
            current_statement_begin__ = 438;
            if (as_bool((primitive_value(smooth_inc) && primitive_value(logical_negation(sinc_isfixed))))) {
                current_statement_begin__ = 439;
                lp_accum__.add(gamma_log<propto__>(lambda_inc, 2, get_base1(sprior, 1, "sprior", 1)));
            }
            current_statement_begin__ = 441;
            if (as_bool((primitive_value(smooth_rem) && primitive_value(logical_negation(srem_isfixed))))) {
                current_statement_begin__ = 442;
                lp_accum__.add(gamma_log<propto__>(lambda_rem, 2, get_base1(sprior, 3, "sprior", 1)));
            }
            current_statement_begin__ = 444;
            if (as_bool((primitive_value((primitive_value(logical_negation(interceptonly)) && primitive_value(logical_negation(increasing)))) && primitive_value(logical_negation(const_cf))))) {
                current_statement_begin__ = 446;
                lp_accum__.add(gamma_log<propto__>(sd_slope, gpslope_a, gpslope_b));
            }
            current_statement_begin__ = 449;
            lp_accum__.add(gamma_log<propto__>(sd_inter, gpint_a, gpint_b));
            current_statement_begin__ = 451;
            if (as_bool(logical_gt(ng, 1))) {
                current_statement_begin__ = 452;
                if (as_bool((primitive_value(logical_negation(const_cf)) && primitive_value(logical_negation(scfmale_isfixed))))) {
                    current_statement_begin__ = 453;
                    lp_accum__.add(gamma_log<propto__>(lambda_cf_male, 2, get_base1(sprior, 2, "sprior", 1)));
                }
                current_statement_begin__ = 457;
                for (int i = 1; i <= (K - 2); ++i) {
                    current_statement_begin__ = 458;
                    lp_accum__.add(normal_log<propto__>(get_base1(bmale, i, "bmale", 1), 0, lambda_cf_male_use));
                }
                current_statement_begin__ = 461;
                lp_accum__.add(normal_log<propto__>(get_base1(bmale, (K - 1), "bmale", 1), 0, gender_slope_priorsd));
                current_statement_begin__ = 463;
                lp_accum__.add(normal_log<propto__>(get_base1(bmale, K, "bmale", 1), 0, gender_int_priorsd));
            }
            current_statement_begin__ = 469;
            if (as_bool(logical_negation(smooth_inc))) {
                current_statement_begin__ = 470;
                for (int a = 1; a <= nage; ++a) {
                    current_statement_begin__ = 471;
                    for (int j = 1; j <= narea; ++j) {
                        current_statement_begin__ = 472;
                        for (int g = 1; g <= ng; ++g) {
                            current_statement_begin__ = 473;
                            lp_accum__.add(gamma_log<propto__>(get_base1(get_base1(get_base1(inc_par, a, "inc_par", 1), j, "inc_par", 2), g, "inc_par", 3), get_base1(inc_prior, 1, "inc_prior", 1), get_base1(inc_prior, 2, "inc_prior", 1)));
                        }
                    }
                }
            }
            current_statement_begin__ = 479;
            if (as_bool(prev_zero)) {
                current_statement_begin__ = 480;
                for (int j = 1; j <= narea; ++j) {
                    current_statement_begin__ = 481;
                    for (int g = 1; g <= ng; ++g) {
                        current_statement_begin__ = 482;
                        lp_accum__.add(beta_log<propto__>(get_base1(get_base1(prevzero, j, "prevzero", 1), g, "prevzero", 2), 2, 2));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("inc_par");
        names__.push_back("rem_par");
        names__.push_back("barea");
        names__.push_back("barea_slope");
        names__.push_back("barea_inter");
        names__.push_back("bmale");
        names__.push_back("lcfbase");
        names__.push_back("beta_inc");
        names__.push_back("beta_rem");
        names__.push_back("mean_inter");
        names__.push_back("sd_inter");
        names__.push_back("mean_slope");
        names__.push_back("sd_slope");
        names__.push_back("lambda_cf");
        names__.push_back("lambda_cf_male");
        names__.push_back("lambda_inc");
        names__.push_back("lambda_rem");
        names__.push_back("prevzero");
        names__.push_back("inc");
        names__.push_back("cf");
        names__.push_back("dcf");
        names__.push_back("inc_prob");
        names__.push_back("prev_prob");
        names__.push_back("mort_prob");
        names__.push_back("rem");
        names__.push_back("rem_prob");
        names__.push_back("cf_prob");
        names__.push_back("state_probs");
        names__.push_back("tmp");
        names__.push_back("P");
        names__.push_back("sdint_use");
        names__.push_back("sdslope_use");
        names__.push_back("bareat");
        names__.push_back("beta");
        names__.push_back("lambda_cf_use");
        names__.push_back("lambda_cf_male_use");
        names__.push_back("lambda_inc_use");
        names__.push_back("lambda_rem_use");
        names__.push_back("lcfbase_use");
        names__.push_back("ll_mort");
        names__.push_back("ll_inc");
        names__.push_back("ll_prev");
        names__.push_back("ll_rem");
        names__.push_back("ll_overall");
        names__.push_back("i");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((nage * (1 - smooth_inc)));
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((K - 2) * (1 - const_cf)));
        dims__.push_back(((narea * (1 - common)) + (1 * common)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((1 - interceptonly) * (1 - const_cf)));
        dims__.push_back(((narea * (1 - common)) + (1 * common)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(1);
        dims__.push_back((narea * (1 - common)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * (ng - 1)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((((narea * (1 - common)) + (1 * common)) * increasing));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * smooth_inc));
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * smooth_rem));
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((1 - sd_int_isfixed));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((1 - const_cf));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((1 - const_cf) * (1 - scf_isfixed)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((ng - 1) * (1 - scfmale_isfixed)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((smooth_inc * (1 - sinc_isfixed)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((remission * smooth_rem) * (1 - srem_isfixed)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((narea * prev_zero));
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * increasing));
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * remission));
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage + 1));
        dims__.push_back(narea);
        dims__.push_back(ng);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(narea);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(narea);
        dims__.push_back(ng);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((narea * increasing));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((nage * narea) * ng));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((nage * narea) * ng));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((nage * narea) * ng));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((((nage * narea) * ng) * remission));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((((nage * narea) * ng) * (3 + remission)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_disbayes_hier_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<std::vector<std::vector<double> > > inc_par;
        size_t inc_par_d_0_max__ = (nage * (1 - smooth_inc));
        size_t inc_par_d_1_max__ = narea;
        size_t inc_par_d_2_max__ = ng;
        inc_par.resize(inc_par_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < inc_par_d_0_max__; ++d_0__) {
            inc_par[d_0__].resize(inc_par_d_1_max__);
            for (size_t d_1__ = 0; d_1__ < inc_par_d_1_max__; ++d_1__) {
                inc_par[d_0__][d_1__].reserve(inc_par_d_2_max__);
                for (size_t d_2__ = 0; d_2__ < inc_par_d_2_max__; ++d_2__) {
                    inc_par[d_0__][d_1__].push_back(in__.scalar_lb_constrain(0));
                }
            }
        }
        size_t inc_par_k_0_max__ = (nage * (1 - smooth_inc));
        size_t inc_par_k_1_max__ = narea;
        size_t inc_par_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < inc_par_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < inc_par_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < inc_par_k_0_max__; ++k_0__) {
                    vars__.push_back(inc_par[k_0__][k_1__][k_2__]);
                }
            }
        }
        std::vector<std::vector<double> > rem_par;
        size_t rem_par_d_0_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        size_t rem_par_d_1_max__ = ng;
        rem_par.resize(rem_par_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rem_par_d_0_max__; ++d_0__) {
            rem_par[d_0__].reserve(rem_par_d_1_max__);
            for (size_t d_1__ = 0; d_1__ < rem_par_d_1_max__; ++d_1__) {
                rem_par[d_0__].push_back(in__.scalar_lb_constrain(0));
            }
        }
        size_t rem_par_k_0_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        size_t rem_par_k_1_max__ = ng;
        for (size_t k_1__ = 0; k_1__ < rem_par_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < rem_par_k_0_max__; ++k_0__) {
                vars__.push_back(rem_par[k_0__][k_1__]);
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> barea = in__.matrix_constrain(((K - 2) * (1 - const_cf)), ((narea * (1 - common)) + (1 * common)));
        size_t barea_j_2_max__ = ((narea * (1 - common)) + (1 * common));
        size_t barea_j_1_max__ = ((K - 2) * (1 - const_cf));
        for (size_t j_2__ = 0; j_2__ < barea_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_j_1_max__; ++j_1__) {
                vars__.push_back(barea(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> barea_slope = in__.matrix_constrain(((1 - interceptonly) * (1 - const_cf)), ((narea * (1 - common)) + (1 * common)));
        size_t barea_slope_j_2_max__ = ((narea * (1 - common)) + (1 * common));
        size_t barea_slope_j_1_max__ = ((1 - interceptonly) * (1 - const_cf));
        for (size_t j_2__ = 0; j_2__ < barea_slope_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_slope_j_1_max__; ++j_1__) {
                vars__.push_back(barea_slope(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> barea_inter = in__.matrix_constrain(1, (narea * (1 - common)));
        size_t barea_inter_j_2_max__ = (narea * (1 - common));
        size_t barea_inter_j_1_max__ = 1;
        for (size_t j_2__ = 0; j_2__ < barea_inter_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_inter_j_1_max__; ++j_1__) {
                vars__.push_back(barea_inter(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> bmale = in__.vector_constrain((K * (ng - 1)));
        size_t bmale_j_1_max__ = (K * (ng - 1));
        for (size_t j_1__ = 0; j_1__ < bmale_j_1_max__; ++j_1__) {
            vars__.push_back(bmale(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lcfbase = in__.vector_constrain((((narea * (1 - common)) + (1 * common)) * increasing));
        size_t lcfbase_j_1_max__ = (((narea * (1 - common)) + (1 * common)) * increasing);
        for (size_t j_1__ = 0; j_1__ < lcfbase_j_1_max__; ++j_1__) {
            vars__.push_back(lcfbase(j_1__));
        }
        std::vector<std::vector<std::vector<double> > > beta_inc;
        size_t beta_inc_d_0_max__ = (K * smooth_inc);
        size_t beta_inc_d_1_max__ = narea;
        size_t beta_inc_d_2_max__ = ng;
        beta_inc.resize(beta_inc_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < beta_inc_d_0_max__; ++d_0__) {
            beta_inc[d_0__].resize(beta_inc_d_1_max__);
            for (size_t d_1__ = 0; d_1__ < beta_inc_d_1_max__; ++d_1__) {
                beta_inc[d_0__][d_1__].reserve(beta_inc_d_2_max__);
                for (size_t d_2__ = 0; d_2__ < beta_inc_d_2_max__; ++d_2__) {
                    beta_inc[d_0__][d_1__].push_back(in__.scalar_constrain());
                }
            }
        }
        size_t beta_inc_k_0_max__ = (K * smooth_inc);
        size_t beta_inc_k_1_max__ = narea;
        size_t beta_inc_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < beta_inc_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < beta_inc_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_inc_k_0_max__; ++k_0__) {
                    vars__.push_back(beta_inc[k_0__][k_1__][k_2__]);
                }
            }
        }
        std::vector<std::vector<std::vector<double> > > beta_rem;
        size_t beta_rem_d_0_max__ = (K * smooth_rem);
        size_t beta_rem_d_1_max__ = narea;
        size_t beta_rem_d_2_max__ = ng;
        beta_rem.resize(beta_rem_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < beta_rem_d_0_max__; ++d_0__) {
            beta_rem[d_0__].resize(beta_rem_d_1_max__);
            for (size_t d_1__ = 0; d_1__ < beta_rem_d_1_max__; ++d_1__) {
                beta_rem[d_0__][d_1__].reserve(beta_rem_d_2_max__);
                for (size_t d_2__ = 0; d_2__ < beta_rem_d_2_max__; ++d_2__) {
                    beta_rem[d_0__][d_1__].push_back(in__.scalar_constrain());
                }
            }
        }
        size_t beta_rem_k_0_max__ = (K * smooth_rem);
        size_t beta_rem_k_1_max__ = narea;
        size_t beta_rem_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < beta_rem_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < beta_rem_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_rem_k_0_max__; ++k_0__) {
                    vars__.push_back(beta_rem[k_0__][k_1__][k_2__]);
                }
            }
        }
        double mean_inter = in__.scalar_constrain();
        vars__.push_back(mean_inter);
        Eigen::Matrix<double, Eigen::Dynamic, 1> sd_inter = in__.vector_lb_constrain(0, (1 - sd_int_isfixed));
        size_t sd_inter_j_1_max__ = (1 - sd_int_isfixed);
        for (size_t j_1__ = 0; j_1__ < sd_inter_j_1_max__; ++j_1__) {
            vars__.push_back(sd_inter(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> mean_slope = in__.vector_constrain((1 - const_cf));
        size_t mean_slope_j_1_max__ = (1 - const_cf);
        for (size_t j_1__ = 0; j_1__ < mean_slope_j_1_max__; ++j_1__) {
            vars__.push_back(mean_slope(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sd_slope = in__.vector_lb_constrain(0, ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed)));
        size_t sd_slope_j_1_max__ = ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed));
        for (size_t j_1__ = 0; j_1__ < sd_slope_j_1_max__; ++j_1__) {
            vars__.push_back(sd_slope(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_cf = in__.vector_lb_constrain(0, ((1 - const_cf) * (1 - scf_isfixed)));
        size_t lambda_cf_j_1_max__ = ((1 - const_cf) * (1 - scf_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_cf(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_cf_male = in__.vector_lb_constrain(0, ((ng - 1) * (1 - scfmale_isfixed)));
        size_t lambda_cf_male_j_1_max__ = ((ng - 1) * (1 - scfmale_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_male_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_cf_male(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_inc = in__.vector_lb_constrain(0, (smooth_inc * (1 - sinc_isfixed)));
        size_t lambda_inc_j_1_max__ = (smooth_inc * (1 - sinc_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_inc_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_inc(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_rem = in__.vector_lb_constrain(0, ((remission * smooth_rem) * (1 - srem_isfixed)));
        size_t lambda_rem_j_1_max__ = ((remission * smooth_rem) * (1 - srem_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_rem_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_rem(j_1__));
        }
        std::vector<std::vector<double> > prevzero;
        size_t prevzero_d_0_max__ = (narea * prev_zero);
        size_t prevzero_d_1_max__ = ng;
        prevzero.resize(prevzero_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < prevzero_d_0_max__; ++d_0__) {
            prevzero[d_0__].reserve(prevzero_d_1_max__);
            for (size_t d_1__ = 0; d_1__ < prevzero_d_1_max__; ++d_1__) {
                prevzero[d_0__].push_back(in__.scalar_lub_constrain(0, 1));
            }
        }
        size_t prevzero_k_0_max__ = (narea * prev_zero);
        size_t prevzero_k_1_max__ = ng;
        for (size_t k_1__ = 0; k_1__ < prevzero_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < prevzero_k_0_max__; ++k_0__) {
                vars__.push_back(prevzero[k_0__][k_1__]);
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 192;
            validate_non_negative_index("inc", "nage", nage);
            validate_non_negative_index("inc", "narea", narea);
            validate_non_negative_index("inc", "ng", ng);
            std::vector<std::vector<std::vector<double> > > inc(nage, std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(inc, DUMMY_VAR__);
            stan::math::fill(inc, DUMMY_VAR__);
            current_statement_begin__ = 193;
            validate_non_negative_index("cf", "nage", nage);
            validate_non_negative_index("cf", "narea", narea);
            validate_non_negative_index("cf", "ng", ng);
            std::vector<std::vector<std::vector<double> > > cf(nage, std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(cf, DUMMY_VAR__);
            stan::math::fill(cf, DUMMY_VAR__);
            current_statement_begin__ = 194;
            validate_non_negative_index("dcf", "(nage * increasing)", (nage * increasing));
            validate_non_negative_index("dcf", "narea", narea);
            validate_non_negative_index("dcf", "ng", ng);
            std::vector<std::vector<std::vector<double> > > dcf((nage * increasing), std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(dcf, DUMMY_VAR__);
            stan::math::fill(dcf, DUMMY_VAR__);
            current_statement_begin__ = 195;
            validate_non_negative_index("inc_prob", "nage", nage);
            validate_non_negative_index("inc_prob", "narea", narea);
            validate_non_negative_index("inc_prob", "ng", ng);
            std::vector<std::vector<std::vector<double> > > inc_prob(nage, std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(inc_prob, DUMMY_VAR__);
            stan::math::fill(inc_prob, DUMMY_VAR__);
            current_statement_begin__ = 196;
            validate_non_negative_index("prev_prob", "nage", nage);
            validate_non_negative_index("prev_prob", "narea", narea);
            validate_non_negative_index("prev_prob", "ng", ng);
            std::vector<std::vector<std::vector<double> > > prev_prob(nage, std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(prev_prob, DUMMY_VAR__);
            stan::math::fill(prev_prob, DUMMY_VAR__);
            current_statement_begin__ = 197;
            validate_non_negative_index("mort_prob", "nage", nage);
            validate_non_negative_index("mort_prob", "narea", narea);
            validate_non_negative_index("mort_prob", "ng", ng);
            std::vector<std::vector<std::vector<double> > > mort_prob(nage, std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(mort_prob, DUMMY_VAR__);
            stan::math::fill(mort_prob, DUMMY_VAR__);
            current_statement_begin__ = 198;
            validate_non_negative_index("rem", "nage", nage);
            validate_non_negative_index("rem", "narea", narea);
            validate_non_negative_index("rem", "ng", ng);
            std::vector<std::vector<std::vector<double> > > rem(nage, std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(rem, DUMMY_VAR__);
            stan::math::fill(rem, DUMMY_VAR__);
            current_statement_begin__ = 199;
            validate_non_negative_index("rem_prob", "(nage * remission)", (nage * remission));
            validate_non_negative_index("rem_prob", "narea", narea);
            validate_non_negative_index("rem_prob", "ng", ng);
            std::vector<std::vector<std::vector<double> > > rem_prob((nage * remission), std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(rem_prob, DUMMY_VAR__);
            stan::math::fill(rem_prob, DUMMY_VAR__);
            current_statement_begin__ = 200;
            validate_non_negative_index("cf_prob", "nage", nage);
            validate_non_negative_index("cf_prob", "narea", narea);
            validate_non_negative_index("cf_prob", "ng", ng);
            std::vector<std::vector<std::vector<double> > > cf_prob(nage, std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(cf_prob, DUMMY_VAR__);
            stan::math::fill(cf_prob, DUMMY_VAR__);
            current_statement_begin__ = 201;
            validate_non_negative_index("state_probs", "3", 3);
            validate_non_negative_index("state_probs", "(nage + 1)", (nage + 1));
            validate_non_negative_index("state_probs", "narea", narea);
            validate_non_negative_index("state_probs", "ng", ng);
            std::vector<std::vector<std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > > > state_probs((nage + 1), std::vector<std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > >(narea, std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> >(ng, Eigen::Matrix<double, 1, Eigen::Dynamic>(3))));
            stan::math::initialize(state_probs, DUMMY_VAR__);
            stan::math::fill(state_probs, DUMMY_VAR__);
            current_statement_begin__ = 202;
            validate_non_negative_index("tmp", "3", 3);
            Eigen::Matrix<double, 1, Eigen::Dynamic> tmp(3);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            current_statement_begin__ = 203;
            validate_non_negative_index("P", "3", 3);
            validate_non_negative_index("P", "3", 3);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
            stan::math::initialize(P, DUMMY_VAR__);
            stan::math::fill(P, DUMMY_VAR__);
            current_statement_begin__ = 204;
            double sdint_use;
            (void) sdint_use;  // dummy to suppress unused var warning
            stan::math::initialize(sdint_use, DUMMY_VAR__);
            stan::math::fill(sdint_use, DUMMY_VAR__);
            current_statement_begin__ = 205;
            double sdslope_use;
            (void) sdslope_use;  // dummy to suppress unused var warning
            stan::math::initialize(sdslope_use, DUMMY_VAR__);
            stan::math::fill(sdslope_use, DUMMY_VAR__);
            current_statement_begin__ = 207;
            validate_non_negative_index("bareat", "K", K);
            validate_non_negative_index("bareat", "narea", narea);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> bareat(K, narea);
            stan::math::initialize(bareat, DUMMY_VAR__);
            stan::math::fill(bareat, DUMMY_VAR__);
            current_statement_begin__ = 208;
            validate_non_negative_index("beta", "K", K);
            validate_non_negative_index("beta", "narea", narea);
            validate_non_negative_index("beta", "ng", ng);
            std::vector<std::vector<std::vector<double> > > beta(K, std::vector<std::vector<double> >(narea, std::vector<double>(ng, double(0))));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 209;
            double lambda_cf_use;
            (void) lambda_cf_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_cf_use, DUMMY_VAR__);
            stan::math::fill(lambda_cf_use, DUMMY_VAR__);
            current_statement_begin__ = 210;
            double lambda_cf_male_use;
            (void) lambda_cf_male_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_cf_male_use, DUMMY_VAR__);
            stan::math::fill(lambda_cf_male_use, DUMMY_VAR__);
            current_statement_begin__ = 211;
            double lambda_inc_use;
            (void) lambda_inc_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_inc_use, DUMMY_VAR__);
            stan::math::fill(lambda_inc_use, DUMMY_VAR__);
            current_statement_begin__ = 212;
            double lambda_rem_use;
            (void) lambda_rem_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_rem_use, DUMMY_VAR__);
            stan::math::fill(lambda_rem_use, DUMMY_VAR__);
            current_statement_begin__ = 213;
            validate_non_negative_index("lcfbase_use", "(narea * increasing)", (narea * increasing));
            Eigen::Matrix<double, Eigen::Dynamic, 1> lcfbase_use((narea * increasing));
            stan::math::initialize(lcfbase_use, DUMMY_VAR__);
            stan::math::fill(lcfbase_use, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 215;
            if (as_bool(sd_int_isfixed)) {
                current_statement_begin__ = 215;
                stan::math::assign(sdint_use, sd_int_fixed);
            } else {
                current_statement_begin__ = 215;
                stan::math::assign(sdint_use, get_base1(sd_inter, 1, "sd_inter", 1));
            }
            current_statement_begin__ = 216;
            if (as_bool((primitive_value((primitive_value((primitive_value(sd_slope_isfixed) || primitive_value(const_cf))) || primitive_value(interceptonly))) || primitive_value(increasing)))) {
                current_statement_begin__ = 216;
                stan::math::assign(sdslope_use, sd_slope_fixed);
            } else {
                current_statement_begin__ = 216;
                stan::math::assign(sdslope_use, get_base1(sd_slope, 1, "sd_slope", 1));
            }
            current_statement_begin__ = 217;
            if (as_bool((primitive_value(scf_isfixed) || primitive_value(const_cf)))) {
                current_statement_begin__ = 217;
                stan::math::assign(lambda_cf_use, lambda_cf_fixed);
            } else {
                current_statement_begin__ = 217;
                stan::math::assign(lambda_cf_use, get_base1(lambda_cf, 1, "lambda_cf", 1));
            }
            current_statement_begin__ = 218;
            if (as_bool((primitive_value(scfmale_isfixed) || primitive_value(logical_eq(ng, 1))))) {
                current_statement_begin__ = 218;
                stan::math::assign(lambda_cf_male_use, lambda_cf_male_fixed);
            } else {
                current_statement_begin__ = 218;
                stan::math::assign(lambda_cf_male_use, get_base1(lambda_cf_male, 1, "lambda_cf_male", 1));
            }
            current_statement_begin__ = 219;
            if (as_bool((primitive_value(sinc_isfixed) || primitive_value(logical_negation(smooth_inc))))) {
                current_statement_begin__ = 219;
                stan::math::assign(lambda_inc_use, lambda_inc_fixed);
            } else {
                current_statement_begin__ = 219;
                stan::math::assign(lambda_inc_use, get_base1(lambda_inc, 1, "lambda_inc", 1));
            }
            current_statement_begin__ = 220;
            if (as_bool((primitive_value(srem_isfixed) || primitive_value(logical_negation(smooth_rem))))) {
                current_statement_begin__ = 220;
                stan::math::assign(lambda_rem_use, lambda_rem_fixed);
            } else {
                current_statement_begin__ = 220;
                stan::math::assign(lambda_rem_use, get_base1(lambda_rem, 1, "lambda_rem", 1));
            }
            current_statement_begin__ = 222;
            for (int j = 1; j <= narea; ++j) {
                current_statement_begin__ = 223;
                if (as_bool(common)) {
                    current_statement_begin__ = 224;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 224;
                        stan::model::assign(lcfbase_use, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    get_base1(lcfbase, 1, "lcfbase", 1), 
                                    "assigning variable lcfbase_use");
                    }
                    current_statement_begin__ = 225;
                    if (as_bool(const_cf)) {
                        current_statement_begin__ = 226;
                        for (int i = 1; i <= (K - 1); ++i) {
                            current_statement_begin__ = 227;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        0, 
                                        "assigning variable bareat");
                        }
                    } else {
                        current_statement_begin__ = 230;
                        for (int i = 1; i <= (K - 2); ++i) {
                            current_statement_begin__ = 231;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(barea, i, 1, "barea", 1) * lambda_cf_use), 
                                        "assigning variable bareat");
                        }
                        current_statement_begin__ = 233;
                        if (as_bool(increasing)) {
                            current_statement_begin__ = 234;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(barea_slope, 1, 1, "barea_slope", 1) * lambda_cf_use), 
                                        "assigning variable bareat");
                        } else {
                            current_statement_begin__ = 236;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        get_base1(mean_slope, 1, "mean_slope", 1), 
                                        "assigning variable bareat");
                        }
                    }
                    current_statement_begin__ = 239;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 240;
                        stan::model::assign(bareat, 
                                    stan::model::cons_list(stan::model::index_uni(K), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    get_base1(mean_slope, 1, "mean_slope", 1), 
                                    "assigning variable bareat");
                    } else {
                        current_statement_begin__ = 242;
                        stan::model::assign(bareat, 
                                    stan::model::cons_list(stan::model::index_uni(K), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    mean_inter, 
                                    "assigning variable bareat");
                    }
                } else {
                    current_statement_begin__ = 247;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 247;
                        stan::model::assign(lcfbase_use, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    get_base1(lcfbase, j, "lcfbase", 1), 
                                    "assigning variable lcfbase_use");
                    }
                    current_statement_begin__ = 248;
                    if (as_bool(const_cf)) {
                        current_statement_begin__ = 249;
                        for (int i = 1; i <= (K - 1); ++i) {
                            current_statement_begin__ = 250;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        0, 
                                        "assigning variable bareat");
                        }
                    } else {
                        current_statement_begin__ = 253;
                        for (int i = 1; i <= (K - 2); ++i) {
                            current_statement_begin__ = 254;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(barea, i, j, "barea", 1) * lambda_cf_use), 
                                        "assigning variable bareat");
                        }
                        current_statement_begin__ = 256;
                        if (as_bool(interceptonly)) {
                            current_statement_begin__ = 257;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        get_base1(mean_slope, 1, "mean_slope", 1), 
                                        "assigning variable bareat");
                        } else if (as_bool(increasing)) {
                            current_statement_begin__ = 259;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(barea_slope, 1, j, "barea_slope", 1) * lambda_cf_use), 
                                        "assigning variable bareat");
                        } else {
                            current_statement_begin__ = 261;
                            stan::model::assign(bareat, 
                                        stan::model::cons_list(stan::model::index_uni((K - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        (get_base1(mean_slope, 1, "mean_slope", 1) + (get_base1(barea_slope, 1, j, "barea_slope", 1) * sdslope_use)), 
                                        "assigning variable bareat");
                        }
                    }
                    current_statement_begin__ = 264;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 265;
                        stan::model::assign(bareat, 
                                    stan::model::cons_list(stan::model::index_uni(K), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    get_base1(mean_slope, 1, "mean_slope", 1), 
                                    "assigning variable bareat");
                    } else {
                        current_statement_begin__ = 267;
                        stan::model::assign(bareat, 
                                    stan::model::cons_list(stan::model::index_uni(K), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    (mean_inter + (get_base1(barea_inter, 1, j, "barea_inter", 1) * sdint_use)), 
                                    "assigning variable bareat");
                    }
                }
            }
            current_statement_begin__ = 273;
            for (int g = 1; g <= ng; ++g) {
                current_statement_begin__ = 274;
                for (int j = 1; j <= narea; ++j) {
                    current_statement_begin__ = 275;
                    for (int a = 1; a <= nage; ++a) {
                        current_statement_begin__ = 276;
                        if (as_bool(smooth_inc)) {
                            current_statement_begin__ = 277;
                            stan::model::assign(inc, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::math::exp(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), to_vector(stan::model::rvalue(beta_inc, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "beta_inc")))), 
                                        "assigning variable inc");
                        } else {
                            current_statement_begin__ = 279;
                            stan::model::assign(inc, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(get_base1(inc_par, a, "inc_par", 1), j, "inc_par", 2), g, "inc_par", 3), 
                                        "assigning variable inc");
                        }
                    }
                    current_statement_begin__ = 282;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 283;
                        if (as_bool(logical_gt(ng, 1))) {
                            current_statement_begin__ = 284;
                            stan::model::assign(beta, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(bareat, k, j, "bareat", 1) + (get_base1(bmale, k, "bmale", 1) * (g - 1))), 
                                        "assigning variable beta");
                        } else {
                            current_statement_begin__ = 286;
                            stan::model::assign(beta, 
                                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        get_base1(bareat, k, j, "bareat", 1), 
                                        "assigning variable beta");
                        }
                    }
                    current_statement_begin__ = 291;
                    if (as_bool((primitive_value(logical_gt(get_base1(get_base1(get_base1(prev_denom, 1, "prev_denom", 1), j, "prev_denom", 2), g, "prev_denom", 3), 0)) && primitive_value((primitive_value(logical_gt(get_base1(get_base1(get_base1(prev_num, 1, "prev_num", 1), j, "prev_num", 2), g, "prev_num", 3), 0)) || primitive_value(prev_zero)))))) {
                        current_statement_begin__ = 292;
                        stan::model::assign(prev_prob, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    get_base1(get_base1(prevzero, j, "prevzero", 1), g, "prevzero", 2), 
                                    "assigning variable prev_prob");
                    } else {
                        current_statement_begin__ = 293;
                        stan::model::assign(prev_prob, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    0, 
                                    "assigning variable prev_prob");
                    }
                    current_statement_begin__ = 294;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())))), 
                                1, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 295;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())))), 
                                0, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 296;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())))), 
                                0, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 298;
                    if (as_bool(increasing)) {
                        current_statement_begin__ = 300;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 301;
                            stan::model::assign(dcf, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::math::exp(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), to_vector(stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "beta")))), 
                                        "assigning variable dcf");
                        }
                        current_statement_begin__ = 304;
                        for (int a = 1; a <= (eqage - 1); ++a) {
                            current_statement_begin__ = 305;
                            stan::model::assign(cf, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::math::exp(get_base1(lcfbase_use, j, "lcfbase_use", 1)), 
                                        "assigning variable cf");
                        }
                        current_statement_begin__ = 307;
                        for (int a = eqage; a <= nage; ++a) {
                            current_statement_begin__ = 308;
                            stan::model::assign(cf, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(cf, (a - 1), "cf", 1), j, "cf", 2), g, "cf", 3) + get_base1(get_base1(get_base1(dcf, a, "dcf", 1), j, "dcf", 2), g, "dcf", 3)), 
                                        "assigning variable cf");
                        }
                    } else {
                        current_statement_begin__ = 315;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 316;
                            stan::model::assign(cf, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::math::exp(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), to_vector(stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "beta")))), 
                                        "assigning variable cf");
                        }
                    }
                    current_statement_begin__ = 320;
                    if (as_bool(remission)) {
                        current_statement_begin__ = 321;
                        if (as_bool(smooth_rem)) {
                            current_statement_begin__ = 322;
                            for (int a = 1; a <= nage; ++a) {
                                current_statement_begin__ = 323;
                                stan::model::assign(rem, 
                                            stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                            stan::math::exp(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), to_vector(stan::model::rvalue(beta_rem, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), "beta_rem")))), 
                                            "assigning variable rem");
                            }
                        } else if (as_bool(const_rem)) {
                            current_statement_begin__ = 327;
                            for (int a = 1; a <= nage; ++a) {
                                current_statement_begin__ = 328;
                                stan::model::assign(rem, 
                                            stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                            get_base1(get_base1(rem_par, 1, "rem_par", 1), g, "rem_par", 2), 
                                            "assigning variable rem");
                            }
                        } else {
                            current_statement_begin__ = 330;
                            stan::model::assign(rem, 
                                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        stan::model::rvalue(rem_par, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list())), "rem_par"), 
                                        "assigning variable rem");
                        }
                    } else {
                        current_statement_begin__ = 331;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 331;
                            stan::model::assign(rem, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        0, 
                                        "assigning variable rem");
                        }
                    }
                    current_statement_begin__ = 332;
                    for (int a = 1; a <= nage; ++a) {
                        current_statement_begin__ = 333;
                        stan::math::assign(P, trans_probs(get_base1(get_base1(get_base1(inc, a, "inc", 1), j, "inc", 2), g, "inc", 3), get_base1(get_base1(get_base1(cf, a, "cf", 1), j, "cf", 2), g, "cf", 3), get_base1(get_base1(get_base1(rem, a, "rem", 1), j, "rem", 2), g, "rem", 3), pstream__));
                        current_statement_begin__ = 334;
                        stan::model::assign(inc_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    bound_prob((get_base1(P, 1, 2, "P", 1) + get_base1(P, 1, 3, "P", 1)), pstream__), 
                                    "assigning variable inc_prob");
                        current_statement_begin__ = 335;
                        if (as_bool(remission)) {
                            current_statement_begin__ = 336;
                            stan::model::assign(rem_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        get_base1(P, 2, 1, "P", 1), 
                                        "assigning variable rem_prob");
                        }
                        current_statement_begin__ = 337;
                        if (as_bool(logical_gt(a, 1))) {
                            current_statement_begin__ = 338;
                            stan::model::assign(prev_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                        (get_base1(get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), j, "state_probs", 2), g, "state_probs", 3), 2, "state_probs", 4) / (get_base1(get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), j, "state_probs", 2), g, "state_probs", 3), 1, "state_probs", 4) + get_base1(get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), j, "state_probs", 2), g, "state_probs", 3), 2, "state_probs", 4))), 
                                        "assigning variable prev_prob");
                        }
                        current_statement_begin__ = 339;
                        stan::math::assign(tmp, multiply(stan::model::rvalue(state_probs, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), "state_probs"), P));
                        current_statement_begin__ = 340;
                        stan::model::assign(state_probs, 
                                    stan::model::cons_list(stan::model::index_uni((a + 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), 
                                    tmp, 
                                    "assigning variable state_probs");
                        current_statement_begin__ = 341;
                        stan::model::assign(cf_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    bound_prob(get_base1(P, 2, 3, "P", 1), pstream__), 
                                    "assigning variable cf_prob");
                        current_statement_begin__ = 342;
                        stan::model::assign(mort_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    ((get_base1(P, 1, 3, "P", 1) * (1 - get_base1(get_base1(get_base1(prev_prob, a, "prev_prob", 1), j, "prev_prob", 2), g, "prev_prob", 3))) + (get_base1(P, 2, 3, "P", 1) * get_base1(get_base1(get_base1(prev_prob, a, "prev_prob", 1), j, "prev_prob", 2), g, "prev_prob", 3))), 
                                    "assigning variable mort_prob");
                        current_statement_begin__ = 344;
                        stan::model::assign(mort_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    bound_prob(get_base1(get_base1(get_base1(mort_prob, a, "mort_prob", 1), j, "mort_prob", 2), g, "mort_prob", 3), pstream__), 
                                    "assigning variable mort_prob");
                        current_statement_begin__ = 345;
                        stan::model::assign(mort_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(g), stan::model::nil_index_list()))), 
                                    bound_prob(get_base1(get_base1(get_base1(mort_prob, a, "mort_prob", 1), j, "mort_prob", 2), g, "mort_prob", 3), pstream__), 
                                    "assigning variable mort_prob");
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 192;
            size_t inc_i_0_max__ = nage;
            size_t inc_i_1_max__ = narea;
            size_t inc_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < inc_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < inc_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < inc_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "inc[i_0__][i_1__][i_2__]", inc[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 193;
            size_t cf_i_0_max__ = nage;
            size_t cf_i_1_max__ = narea;
            size_t cf_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < cf_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < cf_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < cf_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "cf[i_0__][i_1__][i_2__]", cf[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 194;
            size_t dcf_i_0_max__ = (nage * increasing);
            size_t dcf_i_1_max__ = narea;
            size_t dcf_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < dcf_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < dcf_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < dcf_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "dcf[i_0__][i_1__][i_2__]", dcf[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 195;
            size_t inc_prob_i_0_max__ = nage;
            size_t inc_prob_i_1_max__ = narea;
            size_t inc_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < inc_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < inc_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < inc_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "inc_prob[i_0__][i_1__][i_2__]", inc_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 196;
            size_t prev_prob_i_0_max__ = nage;
            size_t prev_prob_i_1_max__ = narea;
            size_t prev_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < prev_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < prev_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < prev_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "prev_prob[i_0__][i_1__][i_2__]", prev_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 197;
            size_t mort_prob_i_0_max__ = nage;
            size_t mort_prob_i_1_max__ = narea;
            size_t mort_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < mort_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < mort_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < mort_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "mort_prob[i_0__][i_1__][i_2__]", mort_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 198;
            size_t rem_i_0_max__ = nage;
            size_t rem_i_1_max__ = narea;
            size_t rem_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < rem_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rem_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < rem_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "rem[i_0__][i_1__][i_2__]", rem[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 199;
            size_t rem_prob_i_0_max__ = (nage * remission);
            size_t rem_prob_i_1_max__ = narea;
            size_t rem_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < rem_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rem_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < rem_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "rem_prob[i_0__][i_1__][i_2__]", rem_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 200;
            size_t cf_prob_i_0_max__ = nage;
            size_t cf_prob_i_1_max__ = narea;
            size_t cf_prob_i_2_max__ = ng;
            for (size_t i_0__ = 0; i_0__ < cf_prob_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < cf_prob_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < cf_prob_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "cf_prob[i_0__][i_1__][i_2__]", cf_prob[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 204;
            check_greater_or_equal(function__, "sdint_use", sdint_use, 0);
            current_statement_begin__ = 205;
            check_greater_or_equal(function__, "sdslope_use", sdslope_use, 0);
            current_statement_begin__ = 209;
            check_greater_or_equal(function__, "lambda_cf_use", lambda_cf_use, 0);
            current_statement_begin__ = 210;
            check_greater_or_equal(function__, "lambda_cf_male_use", lambda_cf_male_use, 0);
            current_statement_begin__ = 211;
            check_greater_or_equal(function__, "lambda_inc_use", lambda_inc_use, 0);
            current_statement_begin__ = 212;
            check_greater_or_equal(function__, "lambda_rem_use", lambda_rem_use, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t inc_k_0_max__ = nage;
                size_t inc_k_1_max__ = narea;
                size_t inc_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < inc_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < inc_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < inc_k_0_max__; ++k_0__) {
                            vars__.push_back(inc[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t cf_k_0_max__ = nage;
                size_t cf_k_1_max__ = narea;
                size_t cf_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < cf_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < cf_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < cf_k_0_max__; ++k_0__) {
                            vars__.push_back(cf[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t dcf_k_0_max__ = (nage * increasing);
                size_t dcf_k_1_max__ = narea;
                size_t dcf_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < dcf_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < dcf_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < dcf_k_0_max__; ++k_0__) {
                            vars__.push_back(dcf[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t inc_prob_k_0_max__ = nage;
                size_t inc_prob_k_1_max__ = narea;
                size_t inc_prob_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < inc_prob_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < inc_prob_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < inc_prob_k_0_max__; ++k_0__) {
                            vars__.push_back(inc_prob[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t prev_prob_k_0_max__ = nage;
                size_t prev_prob_k_1_max__ = narea;
                size_t prev_prob_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < prev_prob_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < prev_prob_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < prev_prob_k_0_max__; ++k_0__) {
                            vars__.push_back(prev_prob[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t mort_prob_k_0_max__ = nage;
                size_t mort_prob_k_1_max__ = narea;
                size_t mort_prob_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < mort_prob_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < mort_prob_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < mort_prob_k_0_max__; ++k_0__) {
                            vars__.push_back(mort_prob[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t rem_k_0_max__ = nage;
                size_t rem_k_1_max__ = narea;
                size_t rem_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < rem_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < rem_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < rem_k_0_max__; ++k_0__) {
                            vars__.push_back(rem[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t rem_prob_k_0_max__ = (nage * remission);
                size_t rem_prob_k_1_max__ = narea;
                size_t rem_prob_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < rem_prob_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < rem_prob_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < rem_prob_k_0_max__; ++k_0__) {
                            vars__.push_back(rem_prob[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t cf_prob_k_0_max__ = nage;
                size_t cf_prob_k_1_max__ = narea;
                size_t cf_prob_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < cf_prob_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < cf_prob_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < cf_prob_k_0_max__; ++k_0__) {
                            vars__.push_back(cf_prob[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t state_probs_j_1_max__ = 3;
                size_t state_probs_k_0_max__ = (nage + 1);
                size_t state_probs_k_1_max__ = narea;
                size_t state_probs_k_2_max__ = ng;
                for (size_t j_1__ = 0; j_1__ < state_probs_j_1_max__; ++j_1__) {
                    for (size_t k_2__ = 0; k_2__ < state_probs_k_2_max__; ++k_2__) {
                        for (size_t k_1__ = 0; k_1__ < state_probs_k_1_max__; ++k_1__) {
                            for (size_t k_0__ = 0; k_0__ < state_probs_k_0_max__; ++k_0__) {
                                vars__.push_back(state_probs[k_0__][k_1__][k_2__](j_1__));
                            }
                        }
                    }
                }
                size_t tmp_j_1_max__ = 3;
                for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                    vars__.push_back(tmp(j_1__));
                }
                size_t P_j_2_max__ = 3;
                size_t P_j_1_max__ = 3;
                for (size_t j_2__ = 0; j_2__ < P_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < P_j_1_max__; ++j_1__) {
                        vars__.push_back(P(j_1__, j_2__));
                    }
                }
                vars__.push_back(sdint_use);
                vars__.push_back(sdslope_use);
                size_t bareat_j_2_max__ = narea;
                size_t bareat_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < bareat_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < bareat_j_1_max__; ++j_1__) {
                        vars__.push_back(bareat(j_1__, j_2__));
                    }
                }
                size_t beta_k_0_max__ = K;
                size_t beta_k_1_max__ = narea;
                size_t beta_k_2_max__ = ng;
                for (size_t k_2__ = 0; k_2__ < beta_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < beta_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                            vars__.push_back(beta[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                vars__.push_back(lambda_cf_use);
                vars__.push_back(lambda_cf_male_use);
                vars__.push_back(lambda_inc_use);
                vars__.push_back(lambda_rem_use);
                size_t lcfbase_use_j_1_max__ = (narea * increasing);
                for (size_t j_1__ = 0; j_1__ < lcfbase_use_j_1_max__; ++j_1__) {
                    vars__.push_back(lcfbase_use(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 489;
            validate_non_negative_index("ll_mort", "((nage * narea) * ng)", ((nage * narea) * ng));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_mort(((nage * narea) * ng));
            stan::math::initialize(ll_mort, DUMMY_VAR__);
            stan::math::fill(ll_mort, DUMMY_VAR__);
            current_statement_begin__ = 490;
            validate_non_negative_index("ll_inc", "((nage * narea) * ng)", ((nage * narea) * ng));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_inc(((nage * narea) * ng));
            stan::math::initialize(ll_inc, DUMMY_VAR__);
            stan::math::fill(ll_inc, DUMMY_VAR__);
            current_statement_begin__ = 491;
            validate_non_negative_index("ll_prev", "((nage * narea) * ng)", ((nage * narea) * ng));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_prev(((nage * narea) * ng));
            stan::math::initialize(ll_prev, DUMMY_VAR__);
            stan::math::fill(ll_prev, DUMMY_VAR__);
            current_statement_begin__ = 492;
            validate_non_negative_index("ll_rem", "(((nage * narea) * ng) * remission)", (((nage * narea) * ng) * remission));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_rem((((nage * narea) * ng) * remission));
            stan::math::initialize(ll_rem, DUMMY_VAR__);
            stan::math::fill(ll_rem, DUMMY_VAR__);
            current_statement_begin__ = 493;
            validate_non_negative_index("ll_overall", "(((nage * narea) * ng) * (3 + remission))", (((nage * narea) * ng) * (3 + remission)));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_overall((((nage * narea) * ng) * (3 + remission)));
            stan::math::initialize(ll_overall, DUMMY_VAR__);
            stan::math::fill(ll_overall, DUMMY_VAR__);
            current_statement_begin__ = 494;
            int i;
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            // generated quantities statements
            current_statement_begin__ = 495;
            for (int a = 1; a <= nage; ++a) {
                current_statement_begin__ = 496;
                for (int j = 1; j <= narea; ++j) {
                    current_statement_begin__ = 497;
                    for (int g = 1; g <= ng; ++g) {
                        current_statement_begin__ = 498;
                        stan::model::assign(ll_mort, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    binomial_log(get_base1(get_base1(get_base1(mort_num, a, "mort_num", 1), j, "mort_num", 2), g, "mort_num", 3), get_base1(get_base1(get_base1(mort_denom, a, "mort_denom", 1), j, "mort_denom", 2), g, "mort_denom", 3), get_base1(get_base1(get_base1(mort_prob, a, "mort_prob", 1), j, "mort_prob", 2), g, "mort_prob", 3)), 
                                    "assigning variable ll_mort");
                        current_statement_begin__ = 499;
                        stan::model::assign(ll_inc, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    binomial_log(get_base1(get_base1(get_base1(inc_num, a, "inc_num", 1), j, "inc_num", 2), g, "inc_num", 3), get_base1(get_base1(get_base1(inc_denom, a, "inc_denom", 1), j, "inc_denom", 2), g, "inc_denom", 3), get_base1(get_base1(get_base1(inc_prob, a, "inc_prob", 1), j, "inc_prob", 2), g, "inc_prob", 3)), 
                                    "assigning variable ll_inc");
                        current_statement_begin__ = 500;
                        stan::model::assign(ll_prev, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    binomial_log(get_base1(get_base1(get_base1(prev_num, a, "prev_num", 1), j, "prev_num", 2), g, "prev_num", 3), get_base1(get_base1(get_base1(prev_denom, a, "prev_denom", 1), j, "prev_denom", 2), g, "prev_denom", 3), get_base1(get_base1(get_base1(prev_prob, a, "prev_prob", 1), j, "prev_prob", 2), g, "prev_prob", 3)), 
                                    "assigning variable ll_prev");
                        current_statement_begin__ = 501;
                        if (as_bool(remission)) {
                            current_statement_begin__ = 502;
                            stan::model::assign(ll_rem, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        binomial_log(get_base1(get_base1(get_base1(rem_num, a, "rem_num", 1), j, "rem_num", 2), g, "rem_num", 3), get_base1(get_base1(get_base1(rem_denom, a, "rem_denom", 1), j, "rem_denom", 2), g, "rem_denom", 3), get_base1(get_base1(get_base1(rem_prob, a, "rem_prob", 1), j, "rem_prob", 2), g, "rem_prob", 3)), 
                                        "assigning variable ll_rem");
                        }
                        current_statement_begin__ = 503;
                        stan::math::assign(i, (i + 1));
                    }
                }
            }
            current_statement_begin__ = 507;
            stan::math::assign(ll_overall, append_row(ll_mort, append_row(ll_inc, append_row(ll_prev, ll_rem))));
            // validate, write generated quantities
            current_statement_begin__ = 489;
            size_t ll_mort_j_1_max__ = ((nage * narea) * ng);
            for (size_t j_1__ = 0; j_1__ < ll_mort_j_1_max__; ++j_1__) {
                vars__.push_back(ll_mort(j_1__));
            }
            current_statement_begin__ = 490;
            size_t ll_inc_j_1_max__ = ((nage * narea) * ng);
            for (size_t j_1__ = 0; j_1__ < ll_inc_j_1_max__; ++j_1__) {
                vars__.push_back(ll_inc(j_1__));
            }
            current_statement_begin__ = 491;
            size_t ll_prev_j_1_max__ = ((nage * narea) * ng);
            for (size_t j_1__ = 0; j_1__ < ll_prev_j_1_max__; ++j_1__) {
                vars__.push_back(ll_prev(j_1__));
            }
            current_statement_begin__ = 492;
            size_t ll_rem_j_1_max__ = (((nage * narea) * ng) * remission);
            for (size_t j_1__ = 0; j_1__ < ll_rem_j_1_max__; ++j_1__) {
                vars__.push_back(ll_rem(j_1__));
            }
            current_statement_begin__ = 493;
            size_t ll_overall_j_1_max__ = (((nage * narea) * ng) * (3 + remission));
            for (size_t j_1__ = 0; j_1__ < ll_overall_j_1_max__; ++j_1__) {
                vars__.push_back(ll_overall(j_1__));
            }
            current_statement_begin__ = 494;
            vars__.push_back(i);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_disbayes_hier";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t inc_par_k_0_max__ = (nage * (1 - smooth_inc));
        size_t inc_par_k_1_max__ = narea;
        size_t inc_par_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < inc_par_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < inc_par_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < inc_par_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "inc_par" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t rem_par_k_0_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        size_t rem_par_k_1_max__ = ng;
        for (size_t k_1__ = 0; k_1__ < rem_par_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < rem_par_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rem_par" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t barea_j_2_max__ = ((narea * (1 - common)) + (1 * common));
        size_t barea_j_1_max__ = ((K - 2) * (1 - const_cf));
        for (size_t j_2__ = 0; j_2__ < barea_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "barea" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t barea_slope_j_2_max__ = ((narea * (1 - common)) + (1 * common));
        size_t barea_slope_j_1_max__ = ((1 - interceptonly) * (1 - const_cf));
        for (size_t j_2__ = 0; j_2__ < barea_slope_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_slope_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "barea_slope" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t barea_inter_j_2_max__ = (narea * (1 - common));
        size_t barea_inter_j_1_max__ = 1;
        for (size_t j_2__ = 0; j_2__ < barea_inter_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_inter_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "barea_inter" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t bmale_j_1_max__ = (K * (ng - 1));
        for (size_t j_1__ = 0; j_1__ < bmale_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bmale" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lcfbase_j_1_max__ = (((narea * (1 - common)) + (1 * common)) * increasing);
        for (size_t j_1__ = 0; j_1__ < lcfbase_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lcfbase" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_inc_k_0_max__ = (K * smooth_inc);
        size_t beta_inc_k_1_max__ = narea;
        size_t beta_inc_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < beta_inc_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < beta_inc_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_inc_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta_inc" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t beta_rem_k_0_max__ = (K * smooth_rem);
        size_t beta_rem_k_1_max__ = narea;
        size_t beta_rem_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < beta_rem_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < beta_rem_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_rem_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta_rem" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_inter";
        param_names__.push_back(param_name_stream__.str());
        size_t sd_inter_j_1_max__ = (1 - sd_int_isfixed);
        for (size_t j_1__ = 0; j_1__ < sd_inter_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sd_inter" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mean_slope_j_1_max__ = (1 - const_cf);
        for (size_t j_1__ = 0; j_1__ < mean_slope_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mean_slope" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sd_slope_j_1_max__ = ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed));
        for (size_t j_1__ = 0; j_1__ < sd_slope_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sd_slope" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_cf_j_1_max__ = ((1 - const_cf) * (1 - scf_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_cf_male_j_1_max__ = ((ng - 1) * (1 - scfmale_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_male_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf_male" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_inc_j_1_max__ = (smooth_inc * (1 - sinc_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_rem_j_1_max__ = ((remission * smooth_rem) * (1 - srem_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t prevzero_k_0_max__ = (narea * prev_zero);
        size_t prevzero_k_1_max__ = ng;
        for (size_t k_1__ = 0; k_1__ < prevzero_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < prevzero_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prevzero" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t inc_k_0_max__ = nage;
            size_t inc_k_1_max__ = narea;
            size_t inc_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < inc_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < inc_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < inc_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "inc" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t cf_k_0_max__ = nage;
            size_t cf_k_1_max__ = narea;
            size_t cf_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < cf_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < cf_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < cf_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "cf" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t dcf_k_0_max__ = (nage * increasing);
            size_t dcf_k_1_max__ = narea;
            size_t dcf_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < dcf_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < dcf_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < dcf_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "dcf" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t inc_prob_k_0_max__ = nage;
            size_t inc_prob_k_1_max__ = narea;
            size_t inc_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < inc_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < inc_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < inc_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "inc_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t prev_prob_k_0_max__ = nage;
            size_t prev_prob_k_1_max__ = narea;
            size_t prev_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < prev_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < prev_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < prev_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "prev_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t mort_prob_k_0_max__ = nage;
            size_t mort_prob_k_1_max__ = narea;
            size_t mort_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < mort_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < mort_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < mort_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "mort_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t rem_k_0_max__ = nage;
            size_t rem_k_1_max__ = narea;
            size_t rem_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < rem_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < rem_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < rem_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "rem" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t rem_prob_k_0_max__ = (nage * remission);
            size_t rem_prob_k_1_max__ = narea;
            size_t rem_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < rem_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < rem_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < rem_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "rem_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t cf_prob_k_0_max__ = nage;
            size_t cf_prob_k_1_max__ = narea;
            size_t cf_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < cf_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < cf_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < cf_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "cf_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t state_probs_j_1_max__ = 3;
            size_t state_probs_k_0_max__ = (nage + 1);
            size_t state_probs_k_1_max__ = narea;
            size_t state_probs_k_2_max__ = ng;
            for (size_t j_1__ = 0; j_1__ < state_probs_j_1_max__; ++j_1__) {
                for (size_t k_2__ = 0; k_2__ < state_probs_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < state_probs_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < state_probs_k_0_max__; ++k_0__) {
                            param_name_stream__.str(std::string());
                            param_name_stream__ << "state_probs" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1 << '.' << j_1__ + 1;
                            param_names__.push_back(param_name_stream__.str());
                        }
                    }
                }
            }
            size_t tmp_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tmp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P_j_2_max__ = 3;
            size_t P_j_1_max__ = 3;
            for (size_t j_2__ = 0; j_2__ < P_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < P_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "P" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "sdint_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "sdslope_use";
            param_names__.push_back(param_name_stream__.str());
            size_t bareat_j_2_max__ = narea;
            size_t bareat_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < bareat_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < bareat_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "bareat" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta_k_0_max__ = K;
            size_t beta_k_1_max__ = narea;
            size_t beta_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < beta_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < beta_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf_male_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_inc_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rem_use";
            param_names__.push_back(param_name_stream__.str());
            size_t lcfbase_use_j_1_max__ = (narea * increasing);
            for (size_t j_1__ = 0; j_1__ < lcfbase_use_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lcfbase_use" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t ll_mort_j_1_max__ = ((nage * narea) * ng);
        for (size_t j_1__ = 0; j_1__ < ll_mort_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_mort" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_inc_j_1_max__ = ((nage * narea) * ng);
        for (size_t j_1__ = 0; j_1__ < ll_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_prev_j_1_max__ = ((nage * narea) * ng);
        for (size_t j_1__ = 0; j_1__ < ll_prev_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_prev" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_rem_j_1_max__ = (((nage * narea) * ng) * remission);
        for (size_t j_1__ = 0; j_1__ < ll_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_overall_j_1_max__ = (((nage * narea) * ng) * (3 + remission));
        for (size_t j_1__ = 0; j_1__ < ll_overall_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_overall" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "i";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t inc_par_k_0_max__ = (nage * (1 - smooth_inc));
        size_t inc_par_k_1_max__ = narea;
        size_t inc_par_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < inc_par_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < inc_par_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < inc_par_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "inc_par" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t rem_par_k_0_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        size_t rem_par_k_1_max__ = ng;
        for (size_t k_1__ = 0; k_1__ < rem_par_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < rem_par_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rem_par" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t barea_j_2_max__ = ((narea * (1 - common)) + (1 * common));
        size_t barea_j_1_max__ = ((K - 2) * (1 - const_cf));
        for (size_t j_2__ = 0; j_2__ < barea_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "barea" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t barea_slope_j_2_max__ = ((narea * (1 - common)) + (1 * common));
        size_t barea_slope_j_1_max__ = ((1 - interceptonly) * (1 - const_cf));
        for (size_t j_2__ = 0; j_2__ < barea_slope_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_slope_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "barea_slope" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t barea_inter_j_2_max__ = (narea * (1 - common));
        size_t barea_inter_j_1_max__ = 1;
        for (size_t j_2__ = 0; j_2__ < barea_inter_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < barea_inter_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "barea_inter" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t bmale_j_1_max__ = (K * (ng - 1));
        for (size_t j_1__ = 0; j_1__ < bmale_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bmale" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lcfbase_j_1_max__ = (((narea * (1 - common)) + (1 * common)) * increasing);
        for (size_t j_1__ = 0; j_1__ < lcfbase_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lcfbase" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_inc_k_0_max__ = (K * smooth_inc);
        size_t beta_inc_k_1_max__ = narea;
        size_t beta_inc_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < beta_inc_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < beta_inc_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_inc_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta_inc" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t beta_rem_k_0_max__ = (K * smooth_rem);
        size_t beta_rem_k_1_max__ = narea;
        size_t beta_rem_k_2_max__ = ng;
        for (size_t k_2__ = 0; k_2__ < beta_rem_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < beta_rem_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_rem_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta_rem" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mean_inter";
        param_names__.push_back(param_name_stream__.str());
        size_t sd_inter_j_1_max__ = (1 - sd_int_isfixed);
        for (size_t j_1__ = 0; j_1__ < sd_inter_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sd_inter" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mean_slope_j_1_max__ = (1 - const_cf);
        for (size_t j_1__ = 0; j_1__ < mean_slope_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mean_slope" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sd_slope_j_1_max__ = ((((1 - const_cf) * (1 - interceptonly)) * (1 - increasing)) * (1 - sd_slope_isfixed));
        for (size_t j_1__ = 0; j_1__ < sd_slope_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sd_slope" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_cf_j_1_max__ = ((1 - const_cf) * (1 - scf_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_cf_male_j_1_max__ = ((ng - 1) * (1 - scfmale_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_male_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf_male" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_inc_j_1_max__ = (smooth_inc * (1 - sinc_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_rem_j_1_max__ = ((remission * smooth_rem) * (1 - srem_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t prevzero_k_0_max__ = (narea * prev_zero);
        size_t prevzero_k_1_max__ = ng;
        for (size_t k_1__ = 0; k_1__ < prevzero_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < prevzero_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prevzero" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t inc_k_0_max__ = nage;
            size_t inc_k_1_max__ = narea;
            size_t inc_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < inc_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < inc_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < inc_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "inc" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t cf_k_0_max__ = nage;
            size_t cf_k_1_max__ = narea;
            size_t cf_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < cf_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < cf_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < cf_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "cf" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t dcf_k_0_max__ = (nage * increasing);
            size_t dcf_k_1_max__ = narea;
            size_t dcf_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < dcf_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < dcf_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < dcf_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "dcf" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t inc_prob_k_0_max__ = nage;
            size_t inc_prob_k_1_max__ = narea;
            size_t inc_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < inc_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < inc_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < inc_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "inc_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t prev_prob_k_0_max__ = nage;
            size_t prev_prob_k_1_max__ = narea;
            size_t prev_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < prev_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < prev_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < prev_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "prev_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t mort_prob_k_0_max__ = nage;
            size_t mort_prob_k_1_max__ = narea;
            size_t mort_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < mort_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < mort_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < mort_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "mort_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t rem_k_0_max__ = nage;
            size_t rem_k_1_max__ = narea;
            size_t rem_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < rem_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < rem_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < rem_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "rem" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t rem_prob_k_0_max__ = (nage * remission);
            size_t rem_prob_k_1_max__ = narea;
            size_t rem_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < rem_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < rem_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < rem_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "rem_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t cf_prob_k_0_max__ = nage;
            size_t cf_prob_k_1_max__ = narea;
            size_t cf_prob_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < cf_prob_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < cf_prob_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < cf_prob_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "cf_prob" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t state_probs_j_1_max__ = 3;
            size_t state_probs_k_0_max__ = (nage + 1);
            size_t state_probs_k_1_max__ = narea;
            size_t state_probs_k_2_max__ = ng;
            for (size_t j_1__ = 0; j_1__ < state_probs_j_1_max__; ++j_1__) {
                for (size_t k_2__ = 0; k_2__ < state_probs_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < state_probs_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < state_probs_k_0_max__; ++k_0__) {
                            param_name_stream__.str(std::string());
                            param_name_stream__ << "state_probs" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1 << '.' << j_1__ + 1;
                            param_names__.push_back(param_name_stream__.str());
                        }
                    }
                }
            }
            size_t tmp_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tmp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P_j_2_max__ = 3;
            size_t P_j_1_max__ = 3;
            for (size_t j_2__ = 0; j_2__ < P_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < P_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "P" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "sdint_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "sdslope_use";
            param_names__.push_back(param_name_stream__.str());
            size_t bareat_j_2_max__ = narea;
            size_t bareat_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < bareat_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < bareat_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "bareat" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta_k_0_max__ = K;
            size_t beta_k_1_max__ = narea;
            size_t beta_k_2_max__ = ng;
            for (size_t k_2__ = 0; k_2__ < beta_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < beta_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf_male_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_inc_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rem_use";
            param_names__.push_back(param_name_stream__.str());
            size_t lcfbase_use_j_1_max__ = (narea * increasing);
            for (size_t j_1__ = 0; j_1__ < lcfbase_use_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lcfbase_use" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t ll_mort_j_1_max__ = ((nage * narea) * ng);
        for (size_t j_1__ = 0; j_1__ < ll_mort_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_mort" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_inc_j_1_max__ = ((nage * narea) * ng);
        for (size_t j_1__ = 0; j_1__ < ll_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_prev_j_1_max__ = ((nage * narea) * ng);
        for (size_t j_1__ = 0; j_1__ < ll_prev_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_prev" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_rem_j_1_max__ = (((nage * narea) * ng) * remission);
        for (size_t j_1__ = 0; j_1__ < ll_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_overall_j_1_max__ = (((nage * narea) * ng) * (3 + remission));
        for (size_t j_1__ = 0; j_1__ < ll_overall_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_overall" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "i";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_disbayes_hier_namespace::model_disbayes_hier stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
