% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badges.R
\name{badges}
\alias{badge_create}
\alias{badges}
\alias{badges_user}
\title{Work with badges}
\usage{
badges(url = NULL, key = NULL, user = NULL, ...)

badges_user(username, url = NULL, key = NULL, user = NULL, ...)

badge_create(name, badge_type_id, description = NULL, allow_title = NULL,
  multiple_grant = NULL, icon = NULL, listable = NULL,
  target_posts = NULL, query = NULL, enabled = NULL, auto_revoke = NULL,
  badge_grouping_id = NULL, trigger = NULL, show_posts = NULL,
  image = NULL, long_description = NULL, url = NULL, key = NULL,
  user = NULL, ...)
}
\arguments{
\item{url}{Base url for a Discourse installation. See \code{\link{disc_setup}}}

\item{key}{Your api key on the Discourse installation. See \code{\link{disc_setup}}}

\item{user}{Your user name on the Discourse installation. See \code{\link{disc_setup}}}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}},
\code{\link[httr]{POST}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{username}{A current user name. required}

\item{name}{(character) A badge name to be created. required}

\item{badge_type_id}{(integer) A badge type id. one of 1 (gold), 2 (silver),
or 3 (bronze). required}

\item{description}{(character) A description(character) . optional}

\item{allow_title}{(logical) Allow a title. optional}

\item{multiple_grant}{(character) multiple grant. optional}

\item{icon}{(character) icon. optional}

\item{listable}{(logical) listable. optional}

\item{target_posts}{(character) . optional}

\item{query}{(character) query string. optional}

\item{enabled}{(logical) enabled or not. optional}

\item{auto_revoke}{(character) auto revoke. optional}

\item{badge_grouping_id}{(character) badge grouping id. optional}

\item{trigger}{(character) trigger. optional}

\item{show_posts}{(logical) show posts. optional}

\item{image}{(character) an image. optional}

\item{long_description}{(character) long description. optional}
}
\description{
Work with badges
}
\examples{
\dontrun{
# all badges
badges()

# specific group by name
badges_user("sckott")

# create a group
(res <- badge_create(name = "funbadge", badge_type_id = 3))
}
}

