% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{plotDisco}
\alias{plotDisco}
\title{plots log2FC of the corresponding genes against each other}
\usage{
plotDisco(x, disco.score, g = NULL)
}
\arguments{
\item{x}{an object of class matchedOrtholog}

\item{disco.score}{a numerical vector of values of disco.score assigned to each orthologous gene pair, ordered according to the gene order in matchedOrtholog object}

\item{g}{either a vector of gene names of genes of interest}
}
\value{
plot
}
\description{
Creates a plot of log2FC of the chosen genes in one data set against log2FC of corresponding genes in the other data set. 
Each dot represents a gene and is colored according to disco.score calculated for this pair of heterologous genes: 
the stronger is red color the more concordantly regulated is the gene pair, and the stronger is the blue color, 
the more discordantly regulated is the gene pair.
}
\examples{
library(tmod)
data(tmod)
data(orthologs)
ds <- disco.score(orthologs)
plotDisco(orthologs, ds, tmod$MODULES2GENES[["LI.M1.0"]])
}
