
<!-- README.md is generated from README.Rmd. Please edit that file -->

# discord

<!-- badges: start -->

[![Project Status: Active – The project has reached a stable, usable
state and is being actively
developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![R package
version](https://www.r-pkg.org/badges/version/discord)](https://cran.r-project.org/package=discord)
[![Package
downloads](https://cranlogs.r-pkg.org/badges/grand-total/discord)](https://cran.r-project.org/package=discord)</br>
[![R-CMD-check](https://github.com/R-Computing-Lab/discord/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/R-Computing-Lab/discord/actions/workflows/R-CMD-check.yaml)
![License](https://img.shields.io/badge/License-GPL_v3-blue.svg)
<!-- badges: end -->

The goal of discord is to provide functions for discordant kinship
modeling and other sibling-based quasi-experimental designs. It has
highly customizable, efficient code for generating genetically-informed
simulations and provides user-friendly functions to perform
discordant-kinship regressions.

## Installation

You can install the official version from CRAN

``` r
# Install/update discord with the release version from CRAN.
install.packages('discord')
```

You can also install/update discord with the development version of
discord from [GitHub](https://github.com/) with:

``` r
# If devtools is not installed, uncomment the line below.
# install.packages('devtools')
devtools::install_github('R-Computing-Lab/discord')
```

## Citation

If you use `discord` in your research or wish to refer to it, please
cite the following paper:

``` r
citation(package = "discord")
To cite package 'discord' in publications use:

  Garrison S, Trattner J, Hwang Y (2025). _discord: Functions for
  Discordant Kinship Modeling_. R package version 1.2.3,
  <https://github.com/R-Computing-Lab/discord>.

A BibTeX entry for LaTeX users is

  @Manual{,
    title = {discord: Functions for Discordant Kinship Modeling},
    author = {S. Mason Garrison and Jonathan Trattner and Yoo Ri Hwang},
    year = {2025},
    note = {R package version 1.2.3},
    url = {https://github.com/R-Computing-Lab/discord},
  }
```

## Contributing

Contributions to the `discord` project are welcome. For guidelines on
how to contribute, please refer to the [Contributing
Guidelines](https://github.com/R-Computing-Lab/discord/blob/main/CONTRIBUTING.md).
Issues and pull requests should be submitted on the GitHub repository.
For support, please use the GitHub issues page.

## License

`discord` is licensed under the GNU General Public License v3.0. For
more details, see the
[LICENSE](https://github.com/R-Computing-Lab/discord/blob/main/LICENSE)
file.
