% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_afcm_utils.R
\name{e_afcmind}
\alias{e_afcmind}
\title{AFCM plot of individuals}
\usage{
e_afcmind(
  modelo,
  axes = c(1, 2),
  colorInd = "steelblue",
  cos2 = 0,
  colorCos = "firebrick",
  titulos = c("Bien Representados", "Mal Representados"),
  etq = T
)
}
\arguments{
\item{modelo}{an object of class AFCM [FactoMineR].}

\item{axes}{a numeric vector of length 2 specifying the dimensions to be plotted.}

\item{colorInd}{a color for the individuals well represented.}

\item{cos2}{a numeric value from 0 to 1 specifying the quality of the individuals.}

\item{colorCos}{a color for individuals badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}

\item{etq}{a boolean, whether to add label to graph or not.}
}
\value{
echarts4r plot
}
\description{
AFCM plot of individuals
}
\examples{
data("poison", package = "FactoMineR")
poison.active <- poison[1:55, 5:15]
p <- FactoMineR::MCA(poison.active, graph = FALSE)
e_afcmind(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
