% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_R6_utils.R
\name{diseasyoption}
\alias{diseasyoption}
\title{Helper function to get option}
\usage{
diseasyoption(option, class = "DiseasystoreBase")
}
\arguments{
\item{option}{(\code{character})\cr
Name of the option to get}

\item{class}{(\code{character} or \verb{R6::R6class Diseasy* instance})\cr
Either the classname or the object the option applies to.}
}
\value{
The most specific option within the diseasy framework for the given option and class
}
\description{
Helper function to get option
}
\examples{
  # Retrieve default option for source conn
  diseasyoption("source_conn")

  # Retrieve DiseasystoreGoogleCovid19 specific option for source conn
  diseasyoption("source_conn", "DiseasystoreGoogleCovid19")

  # Try to retrieve specific option for source conn for a non existent / un-configured diseasystore
  diseasyoption("source_conn", "DiseasystoreNonExistent") # Returns default source_conn
}
