% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/diseq_basic.R,
%   R/diseq_deterministic_adjustment.R, R/diseq_directional.R,
%   R/diseq_stochastic_adjustment.R, R/equilibrium_model.R
\name{initialize_market_model}
\alias{initialize_market_model}
\alias{initialize,diseq_basic-method}
\alias{initialize,diseq_deterministic_adjustment-method}
\alias{initialize,diseq_directional-method}
\alias{initialize,diseq_stochastic_adjustment-method}
\alias{initialize,equilibrium_model-method}
\title{Model initialization}
\usage{
\S4method{initialize}{diseq_basic}(
  .Object,
  key_columns,
  quantity_column,
  price_column,
  demand_specification,
  supply_specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0
)

\S4method{initialize}{diseq_deterministic_adjustment}(
  .Object,
  key_columns,
  time_column,
  quantity_column,
  price_column,
  demand_specification,
  supply_specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0
)

\S4method{initialize}{diseq_directional}(
  .Object,
  key_columns,
  time_column,
  quantity_column,
  price_column,
  demand_specification,
  supply_specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0
)

\S4method{initialize}{diseq_stochastic_adjustment}(
  .Object,
  key_columns,
  time_column,
  quantity_column,
  price_column,
  demand_specification,
  supply_specification,
  price_specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0
)

\S4method{initialize}{equilibrium_model}(
  .Object,
  key_columns,
  quantity_column,
  price_column,
  demand_specification,
  supply_specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0
)
}
\arguments{
\item{.Object}{The object to be Constructed.}

\item{key_columns}{Key columns of the data set.}

\item{quantity_column}{The quantity variable of the data set.}

\item{price_column}{The price variable of the data set.}

\item{demand_specification}{A formula representation of the right hand side of the
demand equation.}

\item{supply_specification}{A formula representation of the right hand side of the
supply equation.}

\item{data}{The data set.}

\item{correlated_shocks}{Should the model be estimated using correlated shocks?}

\item{verbose}{Verbosity level.}

\item{time_column}{The time column of the data set.}

\item{price_specification}{A formula representation of the price equation.}
}
\value{
The initialized model.
}
\description{
Model initialization
}
\details{
## Common initialization

### Variable construction

  The constructor prepares the model's variables using the passed specifications. The
  specification strings are expected to follow the
  syntax of \code{\link[stats]{formula}}. The construction of the model's data uses the variables
  that are extracted by these specification. The demand variables are extracted by a formula that
  uses the \code{quantity_column} on the left hand side and the \code{demand_specification} on
  the right hand side of the formula. The supply variables are constructed by the and the
  \code{quantity_column} and the  \code{supply_specification}. In the case of the
  \code{\linkS4class{diseq_stochastic_adjustment}} model, the price dynamics' variables are
  extracted using the \code{quantity_column} and the \code{price_specification}

### Data preparation

  1. If the passed data set contains rows with NA values, they are dropped. If the verbosity
    level allows warnings, a warning is emitted reporting how many rows were dropped.

  2. After dropping the rows, factor levels may be invalidated. If needed the constructor
    readjusts the factor variables by removing the unobserved levels. Factor indicators and
    interaction terms are automatically created.

  3. The primary column is constructed by pasting the values of the key_columns.

  4. In the case of the \code{\linkS4class{diseq_directional}},
    \code{\linkS4class{diseq_deterministic_adjustment}}, and
    the \code{\linkS4class{diseq_stochastic_adjustment}} models, a column with lagged prices
    is constructed. Since lagged prices are unavailable for the observation of the first
    time points, these observations are dropped. If the verbosity level allows the emission
    of information messages, the constructor prints the number of dropped observations.

  5. In the case of the \code{\linkS4class{diseq_directional}},
    and the \code{\linkS4class{diseq_stochastic_adjustment}} models, a column with price
    differences is created.
}
\section{Functions}{
\itemize{
\item \code{initialize,diseq_basic-method}: Basic disequilibrium model base constructor

\item \code{initialize,diseq_deterministic_adjustment-method}: Disequilibrium model with deterministic price
adjustment constructor

\item \code{initialize,diseq_directional-method}: Directional disequilibrium model base constructor

\item \code{initialize,diseq_stochastic_adjustment-method}: Disequilibrium model with stochastic price
adjustment constructor

\item \code{initialize,equilibrium_model-method}: Full information maximum likelihood model constructor
}}

