% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_chunk.r
\name{remove_chunk}
\alias{remove_chunk}
\title{Removes a chunk from the disk.frame}
\usage{
remove_chunk(df, chunk_id, full.names = FALSE)
}
\arguments{
\item{df}{a disk.frame}

\item{chunk_id}{the chunk ID of the chunk to remove. If it's a number then return number.fst}

\item{full.names}{TRUE or FALSE. Defaults to FALSE. If true then chunk_id is the full path to the chunk otherwise it's the relative path}
}
\description{
Removes a chunk from the disk.frame
}
\examples{
# TODO add these to tests
cars.df = as.disk.frame(cars, nchunks = 4)

# removes 3rd chunk
remove_chunk(cars.df, 3)
nchunks(cars.df) # 3

# removes 4th chunk
remove_chunk(cars.df, "4.fst")
nchunks(cars.df) # 3

# removes 2nd chunk
remove_chunk(cars.df, file.path(attr(cars.df, "path", exact=TRUE), "2.fst"), full.names = TRUE)
nchunks(cars.df) # 1

# clean up cars.df
delete(cars.df)
}
