% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.plot_mztia}
\alias{plot.plot_mztia}
\title{Plot of the mztia simulation}
\usage{
\method{plot}{plot_mztia}(x, ...)
}
\arguments{
\item{x}{An object of class \sQuote{\code{plot_mztia}} returned by the
\code{\link{plot_mztia}()} function.}

\item{...}{Further arguments passed to or from other methods or arguments
that can be passed down to the \code{\link[boot]{plot.boot}()} function.}
}
\value{
The \sQuote{\code{plot_mztia}} object passed to the \code{x}
parameter is returned invisibly.
}
\description{
This is a method for the function \code{plot()} for objects of class
\sQuote{\code{plot_mztia}}.
}
\details{
The element \code{Graph} of the \sQuote{\code{plot_mztia}} object
that is returned by the function \code{\link{plot_mztia}()} is an object
of class \sQuote{\code{ggplot}}, generated by the function
\code{\link[ggplot2]{ggplot}()} from the \sQuote{\code{ggplot2}} package.
Thus, the corresponding \code{plot} method is used for plotting. Arguments
to the \code{\link[ggplot2]{ggplot}()} function can be passed via the
\code{...} parameter.
}
\examples{
# Dissolution data of one reference batch and one test batch of n = 6
# tablets each:
str(dip1)

# 'data.frame':	12 obs. of  10 variables:
# $ type  : Factor w/ 2 levels "R","T": 1 1 1 1 1 1 2 2 2 2 ...
# $ tablet: Factor w/ 6 levels "1","2","3","4",..: 1 2 3 4 5 6 1 2 3 4 ...
# $ t.5   : num  42.1 44.2 45.6 48.5 50.5 ...
# $ t.10  : num  59.9 60.2 55.8 60.4 61.8 ...
# $ t.15  : num  65.6 67.2 65.6 66.5 69.1 ...
# $ t.20  : num  71.8 70.8 70.5 73.1 72.8 ...
# $ t.30  : num  77.8 76.1 76.9 78.5 79 ...
# $ t.60  : num  85.7 83.3 83.9 85 86.9 ...
# $ t.90  : num  93.1 88 86.8 88 89.7 ...
# $ t.120 : num  94.2 89.6 90.1 93.4 90.8 ...

# Assessment of data by aid of the mztia() function
res1 <- mztia(data = dip1, shape = "wide", tcol = 3:10, grouping = "type",
              reference = "R", cap = FALSE)

# The 'mztia' object can be passed on to the plot_mztia() function. This
# function does not produce any output but returns a 'plot_mztia' object.
gg1 <- plot_mztia(res1)
gg2 <- plot(gg1)

# The plot() function returns the 'plot_mztia' object invisibly.
class(gg1)
class(gg2)
}
\seealso{
\code{\link{mztia}}, \code{\link{plot_mztia}},
\code{\link[ggplot2]{ggplot}()}, \code{\link[utils]{methods}}.
}
