% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{rand_indiv_points}
\alias{rand_indiv_points}
\title{Randomisation of individual data points}
\usage{
rand_indiv_points(data, mle)
}
\arguments{
\item{data}{A data frame with the dissolution profile data in wide format.}

\item{mle}{A list of further arguments required for the generation of a
randomised data frame. The first element of \code{mle} is a numeric value
of the number of profiles per batch and the second element is a vector of
indices of the columns containing the profile data.}
}
\value{
A data frame representing a randomised version of the data frame
that has been handed over via the \code{data} parameter.
}
\description{
The function \code{rand_indiv_points()} samples individual data points of
each profile.
}
\details{
The function \code{rand_indiv_points()} samples individual data
points of each profile. The first element of \code{mle} specifies the
number of indices per group (of two groups), i.e. the number of profiles
to take into account from each group. The second element of \code{mle}
specifies the columns in the data frame that represent the dissolution
profiles, i.e. the columns with the \% release data. The data points of
each group and column are randomised.
}
\seealso{
\code{\link{bootstrap_f2}}.
}
\keyword{internal}
