% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blast.R
\name{make_blast_DB}
\alias{make_blast_DB}
\title{Builds local database for BLAST}
\usage{
make_blast_DB(
  makeblastdb.way,
  fasta.way,
  db.way,
  db.type = "nucl",
  db.title,
  delete.fasta = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{makeblastdb.way}{character; name and path to makeblastdb executable file}

\item{fasta.way}{character; name and path to FASTA file}

\item{db.way}{character; name and path to local BLAST database}

\item{db.type}{character; type of BLAST database}

\item{db.title}{character; BLAST data base title}

\item{delete.fasta}{logical; delete FASTA file}

\item{verbose}{logical; show messages}
}
\value{
The function creates local BLAST data base. No additional data is returned.
}
\description{
Builds a BLAST database with local sequences using FASTA file.
}
\details{
This function is using BLAST applications. BLAST+ (UNIX or Windows) should be installed.
}
\examples{
\dontrun{
# This function is using BLAST applications. BLAST+ should be installed.
# FASTA file with sequences for local data base should be downloaded first (see get_seq_for_DB ())
path <- tempdir()
dir.create (path)
# load metadata for target sequences of Chlamydia pneumoniae
(meta.target)
# load sequences, it will take about 3 minutes
get_seq_for_DB (ids = meta.target$gi, db = "nucleotide", check.result = TRUE,
              return="fasta", fasta.file = paste0 (path, "/seq.fasta"), verbose = TRUE)
# create local data base, it will take 0.235217 seconds
make_blast_DB (makeblastdb.way = "D:/Blast/blast-2.11.0+/bin/makeblastdb.exe",
              fasta.way = paste0 (path, "/seq.fasta"), db.title = "Cl_pneumoniae",
              db.way = paste0 (path, "/DB"), db.type = "nucl", delete.fasta = FALSE)
# delete FASTA file (also can set delete.fasta = TRUE)
file.remove (paste0 (path, "/seq.fasta"))
}

}
\references{
Camacho C., Coulouris G., Avagyan V. et al. (2009). BLAST+: architecture and applications. BMC Bioinformatics 10, 421.
\url{https://bmcbioinformatics.biomedcentral.com/articles/10.1186/1471-2105-10-421}.
}
\author{
Elena N. Filatova
}
