% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distantia_spatial.R
\name{distantia_spatial}
\alias{distantia_spatial}
\title{Spatial Representation of \code{distantia()} Data Frames}
\usage{
distantia_spatial(df = NULL, sf = NULL, network = TRUE)
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=distantia]{distantia()}} or \code{\link[=distantia_time_delay]{distantia_time_delay()}}. Default: NULL}

\item{sf}{(required, sf data frame) Points or polygons representing the location of the time series in argument 'df'. It must have a column with all time series names in \code{df$x} and \code{df$y}. Default: NULL}

\item{network}{(optional, logical) If TRUE, the resulting sf data frame is of time LINESTRING and represent network edges. Default: TRUE}
}
\value{
sf data frame (LINESTRING geometry)
}
\description{
Given an sf data frame with geometry types POLYGON, MULTIPOLYGON, or POINT representing time series locations, this function transforms the output of \code{\link[=distantia]{distantia()}}, \code{\link[=distantia_ls]{distantia_ls()}}, \code{\link[=distantia_dtw]{distantia_dtw()}} or \code{\link[=distantia_time_delay]{distantia_time_delay()}} to an sf data frame.

If \code{network = TRUE}, the sf data frame is of type LINESTRING, with edges connecting time series locations. This output is helpful to build many-to-many dissimilarity maps (see examples).

If \code{network = FALSE}, the sf data frame contains the geometry in the input \code{sf} argument. This output helps build one-to-many dissimilarity maps.
}
\examples{
tsl <- distantia::tsl_initialize(
  x = distantia::covid_prevalence,
  name_column = "name",
  time_column = "time"
) |>
distantia::tsl_subset(
  names = c(
    "Los_Angeles",
    "San_Francisco",
    "Fresno",
    "San_Joaquin"
    )
 )

df_psi <- distantia::distantia_ls(
  tsl = tsl
)

#network many to many
sf_psi <- distantia::distantia_spatial(
  df = df_psi,
  sf = distantia::covid_counties,
  network = TRUE
)

#network map
# mapview::mapview(
#   distantia::covid_counties,
#   col.regions = NA,
#   alpha.regions = 0,
#   color = "black",
#   label = "name",
#   legend = FALSE,
#   map.type = "OpenStreetMap"
# ) +
#   mapview::mapview(
#     sf_psi_subset,
#     layer.name = "Psi",
#     label = "edge_name",
#     zcol = "psi",
#     lwd = 3
#   ) |>
#   suppressWarnings()

}
\seealso{
Other distantia_support: 
\code{\link{distantia_aggregate}()},
\code{\link{distantia_boxplot}()},
\code{\link{distantia_cluster_hclust}()},
\code{\link{distantia_cluster_kmeans}()},
\code{\link{distantia_matrix}()},
\code{\link{distantia_model_frame}()},
\code{\link{distantia_stats}()},
\code{\link{distantia_time_delay}()},
\code{\link{utils_block_size}()},
\code{\link{utils_cluster_hclust_optimizer}()},
\code{\link{utils_cluster_kmeans_optimizer}()},
\code{\link{utils_cluster_silhouette}()}
}
\concept{distantia_support}
