% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{f_scale_local}
\alias{f_scale_local}
\title{Data Transformation: Local Centering and Scaling}
\usage{
f_scale_local(x = NULL, center = TRUE, scale = TRUE, ...)
}
\arguments{
\item{x}{(required, zoo object) Zoo time series object to transform.}

\item{center}{(optional, logical or numeric vector) Triggers centering if TRUE. Default: TRUE}

\item{scale}{(optional, logical or numeric vector) Triggers scaling if TRUE. Default: TRUE}

\item{...}{(optional, additional arguments) Ignored in this function.}
}
\value{
zoo object
}
\description{
Scaling and/or centering by variable and time series. Local scaling helps dynamic time warping focus entirely on shape comparisons.
}
\examples{
x <- zoo_simulate()

y <- f_scale_global(
  x = x
)

if(interactive()){
  zoo_plot(x)
  zoo_plot(y)
}
}
\seealso{
Other tsl_transformation: 
\code{\link{f_binary}()},
\code{\link{f_clr}()},
\code{\link{f_detrend_difference}()},
\code{\link{f_detrend_linear}()},
\code{\link{f_detrend_poly}()},
\code{\link{f_hellinger}()},
\code{\link{f_list}()},
\code{\link{f_log}()},
\code{\link{f_percent}()},
\code{\link{f_proportion}()},
\code{\link{f_proportion_sqrt}()},
\code{\link{f_rescale_global}()},
\code{\link{f_rescale_local}()},
\code{\link{f_scale_global}()},
\code{\link{f_trend_linear}()},
\code{\link{f_trend_poly}()}
}
\concept{tsl_transformation}
