% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{f_binary}
\alias{f_binary}
\title{Transform Zoo Object to Binary}
\usage{
f_binary(x = NULL, threshold = NULL)
}
\arguments{
\item{x}{(required, zoo object) Zoo time series object to transform.}

\item{threshold}{(required, numeric) Values greater than this number become 1, others become 0. Set to the mean of the time series by default. Default: NULL}
}
\value{
zoo object
}
\description{
Converts a zoo object to binary (1 and 0) based on a given threshold.
}
\examples{
x <- zoo_simulate(
  data_range = c(0, 1)
  )

y <- f_binary(
  x = x,
  threshold = 0.5
)

if(interactive()){
  zoo_plot(x)
  zoo_plot(y)
}
}
\seealso{
Other tsl_transformation: 
\code{\link{f_clr}()},
\code{\link{f_detrend_difference}()},
\code{\link{f_detrend_linear}()},
\code{\link{f_detrend_poly}()},
\code{\link{f_hellinger}()},
\code{\link{f_list}()},
\code{\link{f_log}()},
\code{\link{f_percent}()},
\code{\link{f_proportion}()},
\code{\link{f_proportion_sqrt}()},
\code{\link{f_rescale_global}()},
\code{\link{f_rescale_local}()},
\code{\link{f_scale_global}()},
\code{\link{f_scale_local}()},
\code{\link{f_trend_linear}()},
\code{\link{f_trend_poly}()}
}
\concept{tsl_transformation}
