% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{f_rescale_local}
\alias{f_rescale_local}
\title{Data Transformation: Local Rescaling of to a New Range}
\usage{
f_rescale_local(
  x = NULL,
  new_min = 0,
  new_max = 1,
  old_min = NULL,
  old_max = NULL,
  ...
)
}
\arguments{
\item{x}{(required, zoo object) Time Series. Default: \code{NULL}}

\item{new_min}{(optional, numeric) New minimum value. Default: \code{0}}

\item{new_max}{(optional_numeric) New maximum value. Default: \code{1}}

\item{old_min}{(optional, numeric) Old minimum value. Default: \code{NULL}}

\item{old_max}{(optional_numeric) Old maximum value. Default: \code{NULL}}

\item{...}{(optional, additional arguments) Ignored in this function.}
}
\value{
zoo object
}
\description{
Data Transformation: Local Rescaling of to a New Range
}
\examples{
x <- zoo_simulate(cols = 2)

y <- f_rescale_global(
  x = x,
  new_min = 0,
  new_max = 100
)

if(interactive()){
  zoo_plot(x)
  zoo_plot(y)
}
}
\seealso{
Other tsl_transformation: 
\code{\link{f_binary}()},
\code{\link{f_clr}()},
\code{\link{f_detrend_difference}()},
\code{\link{f_detrend_linear}()},
\code{\link{f_detrend_poly}()},
\code{\link{f_hellinger}()},
\code{\link{f_list}()},
\code{\link{f_log}()},
\code{\link{f_percent}()},
\code{\link{f_proportion}()},
\code{\link{f_proportion_sqrt}()},
\code{\link{f_rescale_global}()},
\code{\link{f_scale_global}()},
\code{\link{f_scale_local}()},
\code{\link{f_trend_linear}()},
\code{\link{f_trend_poly}()}
}
\concept{tsl_transformation}
