% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_diagnose.R
\name{tsl_diagnose}
\alias{tsl_diagnose}
\title{Diagnose Issues in Time Series Lists}
\usage{
tsl_diagnose(tsl = NULL, full = TRUE)
}
\arguments{
\item{tsl}{(required, list of zoo time series) Time series list to diagnose. Default: NULL}

\item{full}{(optional, logical) If TRUE, a full diagnostic is triggered. Otherwise, only the data structure is tested. Default: TRUE}
}
\value{
invisible
}
\description{
A Time Series List (\code{tsl} for short) is a named list of zoo time series. This type of object, not defined as a class, is used throughout the \code{distantia} package to contain time series data ready for processing and analysis.

The structure and values of a \code{tsl} must fulfill several general conditions:

Structure:
\itemize{
\item List names match the attributes "name" of the zoo time series.
\item Zoo time series must have at least one shared column name.
\item The index (as extracted by \code{\link[zoo:index]{zoo::index()}}) of all zoo objects must be of the same class (either "Date", "POSIXct", "numeric", or "integer").
\item The "core data" (as extracted by \code{\link[zoo:coredata]{zoo::coredata()}}) of univariate zoo time series must be of class "matrix".
}

Values (optional, when \code{full = TRUE}):
\itemize{
\item All time series have at least one shared numeric column.
\item There are no NA, Inf, or NaN values in the time series.
}

This function analyzes a \code{tsl} without modifying it to returns messages describing what conditions are not met, and provides hints on how to fix most issues.
}
\examples{
#creating three zoo time series

#one with NA values
x <- zoo_simulate(
  name = "x",
  cols = 1,
  na_fraction = 0.1
  )

#with different number of columns
#wit repeated name
y <- zoo_simulate(
  name = "x",
  cols = 2
  )

#with different time class
z <- zoo_simulate(
  name = "z",
  cols = 1,
  time_range = c(1, 100)
  )

#adding a few structural issues

#changing the column name of x
colnames(x) <- c("b")

#converting z to vector
z <- zoo::zoo(
  x = runif(nrow(z)),
  order.by = zoo::index(z)
)

#storing zoo objects in a list
#with mismatched names
tsl <- list(
  a = x,
  b = y,
  c = z
)

#running full diagnose
tsl_diagnose(
  tsl = tsl,
  full = TRUE
  )
}
\seealso{
Other tsl_management: 
\code{\link{tsl_burst}()},
\code{\link{tsl_colnames_clean}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_set}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_count_NA}()},
\code{\link{tsl_handle_NA}()},
\code{\link{tsl_join}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_get}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()},
\code{\link{tsl_to_df}()}
}
\concept{tsl_management}
