% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distribution.R
\name{cdf}
\alias{cdf}
\title{Cumulative Distribution Function}
\usage{
cdf(object, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE, data = NULL)
}
\arguments{
\item{object}{(\link{Distribution})}

\item{...}{\code{(numeric())} \cr
Points to evaluate the cumulative distribution function of the distribution. Arguments do not
need to be named. The length of each argument corresponds to the number of points to evaluate,
the number of arguments corresponds to the number of variables in the distribution.
See examples.}

\item{lower.tail}{\code{logical(1)} \cr
If \code{TRUE} (default), probabilities are \code{X <= x}, otherwise, \code{X > x}.}

\item{log.p}{\code{logical(1)} \cr
If \code{TRUE} returns log-cdf. Default is \code{FALSE}.}

\item{simplify}{\code{logical(1)} \cr
If \code{TRUE} (default) simplifies the pdf if possible to a \code{numeric}, otherwise returns a
\link[=data.table]{data.table::data.table}.}

\item{data}{\link{array} \cr
Alternative method to specify points to evaluate. If univariate then rows correspond with number
of points to evaluate and columns correspond with number of variables to evaluate. In the special
case of \link{VectorDistribution}s of multivariate distributions, then the third dimension corresponds
to the distribution in the vector to evaluate.}
}
\value{
Cdf evaluated at given points as either a numeric if \code{simplify} is TRUE
or as a \link[data.table:data.table]{data.table::data.table}.
}
\description{
See \link{Distribution}\verb{$cdf}
}
