% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrSimulate.R
\name{distrSimulate}
\alias{distrSimulate}
\title{Simulate from a Distribution}
\usage{
distrSimulate(
  n = 100,
  distribution = "Normal",
  pars = list(),
  simplify = TRUE,
  seed,
  ...
)
}
\arguments{
\item{n}{number of points to simulate.}

\item{distribution}{distribution to simulate from, corresponds to \code{ClassName} of \code{distr6}
distribution, abbreviations allowed.}

\item{pars}{parameters to pass to \code{distribution}. If omitted then \code{distribution} defaults used.}

\item{simplify}{if \code{TRUE} (default) only the simulations are returned, otherwise the constructed
distribution is also returned.}

\item{seed}{passed to \link{set.seed}}

\item{...}{additional optional arguments for \link{set.seed}}
}
\value{
If \code{simplify} then vector of \code{n} simulations, otherwise list of simulations and
distribution.
}
\description{
Helper function to quickly simulate from a distribution with given parameters.
}
