% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_moments.R
\name{plot_moments}
\alias{plot_moments}
\title{Plot function: Display the influence of a covariate}
\usage{
plot_moments(model, int_var, pred_data, palette = "default",
  rug = FALSE, samples = FALSE, uncertainty = FALSE, ex_fun = NULL)
}
\arguments{
\item{model}{A fitted model on which the plots are based.}

\item{int_var}{The variable for which influences of the moments shall be
graphically displayed. Has to be in character form.}

\item{pred_data}{Combinations of covariate data, sometimes also known as
"newdata", including the variable of interest, which will be ignored in
later processing.}

\item{palette}{See \code{\link{plot_dist}}}

\item{rug}{Should the resulting plot be a rug plot?}

\item{samples}{If the provided model is a bamlss model, should the moment
values be "correctly" calculated, using the transformed samples? See
details for details.}

\item{uncertainty}{If \code{TRUE}, displays uncertainty measures about the
covariate influences. Can only be \code{TRUE} if samples is also
\code{TRUE}.}

\item{ex_fun}{An external function \code{function(par) {...}} which
calculates a measure, which dependency from a certain variable is of
interest.}
}
\description{
This function takes a dataframe of predictions with one row per prediction
and one column for every explanatory variable. Then, those predictions are
held constant while one specific variable is varied over it's whole range
(min-max). Then, the constant variables with the varied interest variables
are predicted and plotted against the expected value and the variance of the
underlying distribution
}
\examples{
library("gamlss")
dat <- model_fam_data(fam_name = "LOGNO")
model <- gamlss(LOGNO ~ ps(norm2) + binomial1,
                ~ ps(norm2) + binomial1,
                data = dat, family = "LOGNO")
ndata <- dat[1:5, c("norm2", "binomial1")]

# Normal plot
plot_moments(model, int_var = "norm2", pred_data = ndata)

# Rug Plot
plot_moments(model, int_var = "norm2", pred_data = ndata, rug = TRUE)

# Using an external function
ineq <- function(par) {
  2 * pnorm((par[["sigma"]] / 2) * sqrt(2)) - 1
}
plot_moments(model, int_var = "norm2", pred_data = ndata, ex_fun = "ineq")

}
