% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bernoulli.R
\name{Bernoulli}
\alias{Bernoulli}
\title{Create a Bernoulli distribution}
\usage{
Bernoulli(p = 0.5)
}
\arguments{
\item{p}{The success probability for the distribution. \code{p} can be any
value in \code{[0, 1]}, and defaults to \code{0.5}.}
}
\value{
A \code{Bernoulli} object.
}
\description{
Bernoulli distributions are used to represent events like coin flips
when there is single trial that is either successful or unsuccessful.
The Bernoulli distribution is a special case of the \code{\link[=Binomial]{Binomial()}}
distribution with \code{n = 1}.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3}, where the math
will render with additional detail.

In the following, let \eqn{X} be a Bernoulli random variable with parameter
\code{p} = \eqn{p}. Some textbooks also define \eqn{q = 1 - p}, or use
\eqn{\pi} instead of \eqn{p}.

The Bernoulli probability  distribution is widely used to model
binary variables, such as 'failure' and 'success'. The most
typical example is the flip of a coin, when  \eqn{p} is thought as the
probability of flipping a head, and \eqn{q = 1 - p} is the
probability of flipping a tail.

\strong{Support}: \eqn{\{0, 1\}}{{0, 1}}

\strong{Mean}: \eqn{p}

\strong{Variance}: \eqn{p \cdot (1 - p) = p \cdot q}{p (1 - p)}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = x) = p^x (1 - p)^{1-x} = p^x q^{1-x}
  }{
    P(X = x) = p^x (1 - p)^(1-x)
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le x) =
    \left \{
      \begin{array}{ll}
        0 & x < 0 \\
        1 - p & 0 \leq x < 1 \\
        1 & x \geq 1
      \end{array}
    \right.
  }{
    P(X \le x) = (1 - p) 1_{[0, 1)}(x) + 1_{1}(x)
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = (1 - p) + p e^t
  }{
    E(e^(tX)) = (1 - p) + p e^t
  }
}
\examples{

set.seed(27)

X <- Bernoulli(0.7)
X

random(X, 10)
pdf(X, 1)
log_pdf(X, 1)
cdf(X, 0)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
\seealso{
Other discrete distributions: \code{\link{Binomial}},
  \code{\link{Categorical}}, \code{\link{Geometric}},
  \code{\link{HyperGeometric}}, \code{\link{Multinomial}},
  \code{\link{NegativeBinomial}}, \code{\link{Poisson}}
}
\concept{discrete distributions}
