% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geometric.R
\name{cdf.Geometric}
\alias{cdf.Geometric}
\title{Evaluate the cumulative distribution function of a Geometric distribution}
\usage{
\method{cdf}{Geometric}(d, x, ...)
}
\arguments{
\item{d}{A \code{Geometric} object created by a call to \code{\link[=Geometric]{Geometric()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the cumulative distribution function of a Geometric distribution
}
\examples{

set.seed(27)

X <- Geometric(0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other Geometric distribution: 
\code{\link{pdf.Geometric}()},
\code{\link{quantile.Geometric}()},
\code{\link{random.Geometric}()}
}
\concept{Geometric distribution}
