% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geometric.R
\name{pdf.Geometric}
\alias{pdf.Geometric}
\alias{log_pdf.Geometric}
\title{Evaluate the probability mass function of a Geometric distribution}
\usage{
\method{pdf}{Geometric}(d, x, drop = TRUE, ...)

\method{log_pdf}{Geometric}(d, x, drop = TRUE, ...)
}
\arguments{
\item{d}{A \code{Geometric} object created by a call to \code{\link[=Geometric]{Geometric()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments to be passed to \code{\link[stats]{dgeom}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Please see the documentation of \code{\link[=Geometric]{Geometric()}} for some properties
of the Geometric distribution, as well as extensive examples
showing to how calculate p-values and confidence intervals.
}
\examples{

set.seed(27)

X <- Geometric(0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other Geometric distribution: 
\code{\link{cdf.Geometric}()},
\code{\link{quantile.Geometric}()},
\code{\link{random.Geometric}()}
}
\concept{Geometric distribution}
