% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{quantile.Weibull}
\alias{quantile.Weibull}
\title{Determine quantiles of a Weibull distribution}
\usage{
\method{quantile}{Weibull}(x, probs, drop = TRUE, ...)
}
\arguments{
\item{x}{A \code{Weibull} object created by a call to \code{\link[=Weibull]{Weibull()}}.}

\item{probs}{A vector of probabilities.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments to be passed to \code{\link[stats]{qweibull}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(probs)} columns (if \code{drop = FALSE}). In case of a vectorized
distribution object, a matrix with \code{length(probs)} columns containing all
possible combinations.
}
\description{
Determine quantiles of a Weibull distribution
}
\examples{

set.seed(27)

X <- Weibull(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other Weibull distribution: 
\code{\link{cdf.Weibull}()},
\code{\link{pdf.Weibull}()},
\code{\link{random.Weibull}()}
}
\concept{Weibull distribution}
