% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethod.R
\name{timeBudget,TDRcalibrate,logical-method}
\alias{timeBudget,TDRcalibrate,logical-method}
\alias{timeBudget}
\title{Describe the Time Budget of Major Activities from "TDRcalibrate"
object.}
\usage{
\S4method{timeBudget}{TDRcalibrate,logical}(obj, ignoreZ)
}
\arguments{
\item{obj}{\code{\link{TDRcalibrate}} object.}

\item{ignoreZ}{logical: whether to ignore trivial aquatic periods.}
}
\value{
A \code{\link{data.frame}} with components:

\item{phaseno}{A numeric vector numbering each period of activity.}

\item{activity}{A factor labelling the period with the corresponding
activity.}

\item{beg, end}{\code{\link{POSIXct}} objects indicating the beginning
and end of each period.}
}
\description{
Summarize the major activities recognized into a time budget.
}
\details{
Ignored trivial aquatic periods are collapsed into the enclosing dry
period.
}
\section{Methods (by class)}{
\itemize{
\item \code{obj = TDRcalibrate,ignoreZ = logical}: Base method for computing time budget from
TDRcalibrate object
}}

\examples{
\donttest{## Too long for checks
## Continuing the Example from '?calibrateDepth':
utils::example("calibrateDepth", package="diveMove",
               ask=FALSE, echo=FALSE, run.donttest=TRUE)
dcalib		# the 'TDRcalibrate' that was created

timeBudget(dcalib, TRUE)

}
}
\seealso{
\code{\link{calibrateDepth}}
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}
}
\keyword{methods}
