% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_phylo.R
\name{div_phylo}
\alias{div_phylo}
\alias{div_phylo.numeric}
\alias{div_phylo.species_distribution}
\title{Phylogenetic Diversity of a Community}
\usage{
div_phylo(x, tree, q = 1, ...)

\method{div_phylo}{numeric}(
  x,
  tree,
  q = 1,
  normalize = TRUE,
  estimator = c("UnveilJ", "ChaoJost", "ChaoShen", "GenCov", "Grassberger", "Marcon",
    "UnveilC", "UnveiliC", "ZhangGrabchak", "naive", "Bonachela", "Holste"),
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{div_phylo}{species_distribution}(
  x,
  tree,
  q = 1,
  normalize = TRUE,
  estimator = c("UnveilJ", "ChaoJost", "ChaoShen", "GenCov", "Grassberger", "Marcon",
    "UnveilC", "UnveiliC", "ZhangGrabchak", "naive", "Bonachela", "Holste"),
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  gamma = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances
or probabilities, or an object of class \link{abundances} or \link{probabilities}.}

\item{tree}{An ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{q}{The order of diversity.}

\item{...}{Unused.}

\item{normalize}{If \code{TRUE}, phylogenetic is normalized: the height of the tree is set to 1.}

\item{estimator}{An estimator of asymptotic diversity.}

\item{level}{The level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
If not \code{NULL}, the asymptotic \code{estimator} is ignored.}

\item{probability_estimator}{A string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{A string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{An estimator of richness to evaluate the total number of species,
see \link{div_richness}. Used for interpolation and extrapolation.}

\item{jack_alpha}{The risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{The highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{An estimator of sample coverage used by \link{coverage}.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{If \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated
diversity
}
\description{
Estimate the diversity of species from abundance or probability data
and a phylogenetic tree.
Several estimators are available to deal with incomplete sampling.
}
\details{
Bias correction requires the number of individuals.
See \link{div_hill} for estimators.

Entropy can be estimated at a specified level of interpolation or
extrapolation, either a chosen sample size or sample coverage
\insertCite{Chao2014}{divent}, rather than its asymptotic value.
See \link{accum_tsallis} for details.
}
\examples{
div_phylo(paracou_6_abd, tree = paracou_6_taxo, q = 2)

# At 80\% coverage
div_phylo(paracou_6_abd, tree = paracou_6_taxo, q = 2, level = 0.8)

# Gamma entropy
div_phylo(paracou_6_abd, tree = paracou_6_taxo, q = 2, gamma = TRUE)

}
\references{
\insertAllCited{}
}
