% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delink.R
\name{delink}
\alias{delink}
\alias{delink.epid}
\alias{delink.pane}
\alias{delink.pid}
\title{Unlink group identifiers}
\usage{
delink(x, lgk, ...)

\method{delink}{epid}(x, lgk, ...)

\method{delink}{pane}(x, lgk, ...)

\method{delink}{pid}(x, lgk, ...)
}
\arguments{
\item{x}{[\code{\link[=epid-class]{epid}|\link[=pid-class]{pid}|\link[=pane-class]{pane}]}}

\item{lgk}{\code{[logical]}. Subset of records to unlink.}

\item{...}{Other arguments.}
}
\value{
\link[=epid-class]{epid}; \link[=pid-class]{pid}; \link[=pane-class]{pane}
}
\description{
Unlink records from an episode (\code{\link[=epid-class]{epid}}), record group (\code{\link[=pid-class]{pid}}) or pane (\code{\link[=pane-class]{pane}}) object.
}
\examples{
ep <- episodes(1:8)
unlinked_ep <- delink(ep, ep@sn \%in\% c(3, 8))
ep; unlinked_ep

pn <- partitions(1:8, length.out = 2, separate = TRUE)
unlinked_pn <- delink(pn, pn@.Data == 5)
pn; unlinked_pn

pd <- links(list(c(1, 1, 1, NA, NA),
                 c(NA, NA, 2, 2, 2)))
unlinked_pd <- delink(pd, pd@pid_cri == 1)
pd; unlinked_pd

# A warning is given if an index record is unlinked as this will lead to seemly impossible links.
ep2 <- episodes(1:8, 2, episode_type = "rolling")
unlinked_ep2 <- delink(ep2, ep2@sn \%in\% c(3, 5))
schema(ep2, custom_label = decode(ep2@case_nm), seed = 2)
schema(unlinked_ep2, custom_label = decode(unlinked_ep2@case_nm), seed = 2)
}
