% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{correlate}
\alias{correlate}
\title{Compute the correlation coefficient between two numerical data}
\usage{
correlate(.data, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, correlate() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.

See vignette("EDA") for an introduction to these concepts.}
}
\description{
The correlate() compute pearson's the correlation
coefficient of the numerical data.
}
\details{
This function is useful when used with the group_by() function of the dplyr package.
If you want to compute by level of the categorical data you are interested in,
rather than the whole observation, you can use \code{\link{grouped_df}} as the group_by() function.
This function is computed stats::cor() function by use = "pairwise.complete.obs" option.
}
\section{Correlation coefficient information}{

The information derived from the numerical data compute is as follows.

\itemize{
\item var1 : names of numerical variable
\item var2 : name of the corresponding numeric variable
\item coef_corr : pearson's correlation coefficient
}
}

\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Correlation coefficients of all numerical variables
correlate(carseats)

# Select the variable to compute
correlate(carseats, Sales, Price)
correlate(carseats, -Sales, -Price)
correlate(carseats, "Sales", "Price")
correlate(carseats, 1)

# Using dplyr::grouped_dt
library(dplyr)

gdata <- group_by(carseats, ShelveLoc, US)
correlate(gdata, "Sales")
correlate(gdata)

# Using pipes ---------------------------------
# Correlation coefficients of all numerical variables
carseats \%>\%
 correlate()
# Positive values select variables
carseats \%>\%
 correlate(Sales, Price)
# Negative values to drop variables
carseats \%>\%
 correlate(-Sales, -Price)
# Positions values select variables
carseats \%>\%
 correlate(1)
# Positions values select variables
carseats \%>\%
 correlate(-1, -2, -3, -5, -6)
# ---------------------------------------------
# Correlation coefficient
# that eliminates redundant combination of variables
carseats \%>\%
 correlate() \%>\%
 filter(as.integer(var1) > as.integer(var2))

carseats \%>\%
 correlate(Sales, Price) \%>\%
 filter(as.integer(var1) > as.integer(var2))

# Using pipes & dplyr -------------------------
# Compute the correlation coefficient of Sales variable by 'ShelveLoc'
# and 'US' variables. And extract only those with absolute
# value of correlation coefficient is greater than 0.5
carseats \%>\%
 group_by(ShelveLoc, US) \%>\%
 correlate(Sales) \%>\%
 filter(abs(coef_corr) >= 0.5)

# extract only those with 'ShelveLoc' variable level is "Good",
# and compute the correlation coefficient of 'Sales' variable
# by 'Urban' and 'US' variables.
# And the correlation coefficient is negative and smaller than 0.5
carseats \%>\%
 filter(ShelveLoc == "Good") \%>\%
 group_by(Urban, US) \%>\%
 correlate(Sales) \%>\%
 filter(coef_corr < 0) \%>\%
 filter(abs(coef_corr) > 0.5)
}
\seealso{
\code{\link{cor}}.
}
