% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_outliers}
\alias{find_outliers}
\title{Finding variables including outliers}
\usage{
find_outliers(.data, index = TRUE, rate = FALSE)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{index}{logical. When representing the information of a variable including
outliers, specify whether or not the variable is represented by an index.
Returns an index if TRUE or a variable names if FALSE.}

\item{rate}{logical. If TRUE, returns the percentage of outliers
in the individual variable.}
}
\value{
Information on variables including outliers.
}
\description{
Find the numerical variable that contains outliers in the object
that inherits the data.frame or data.frame.
}
\examples{
\dontrun{
find_outliers(heartfailure)

find_outliers(heartfailure, index = FALSE)

find_outliers(heartfailure, rate = TRUE)

## using dplyr -------------------------------------
library(dplyr)

# Perform simple data quality diagnosis of variables with outliers.
heartfailure \%>\%
  select(find_outliers(.)) \%>\%
  diagnose()
}
}
\seealso{
\code{\link{find_na}}, \code{\link{imputate_outlier}}.
}
