% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{plot.correlate}
\alias{plot.correlate}
\title{Visualize Information for an "correlate" Object}
\usage{
\method{plot}{correlate}(x, typographic = TRUE, base_family = NULL, ...)
}
\arguments{
\item{x}{an object of class "correlate", usually, a result of a call to correlate().}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).}
}
\description{
Visualize by attribute of `correlate` class.
The plot of correlation matrix is a tile plot.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
\donttest{
library(dplyr)

# correlate type is generic ==================================
tab_corr <- correlate(iris)
tab_corr

# visualize correlate class 
plot(tab_corr)

tab_corr <- iris \%>\% 
  correlate(Sepal.Length, Petal.Length)
tab_corr

# visualize correlate class 
plot(tab_corr)

# correlate type is group ====================================
tab_corr <- iris \%>\% 
  group_by(Species) \%>\% 
  correlate()

# plot correlate class
plot(tab_corr)

# S3 method for correlate class by 'tbl_dbi' ================
# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy iris to the DBMS with a table named TB_IRIS
copy_to(con_sqlite, iris, name = "TB_IRIS", overwrite = TRUE)

# correlation coefficients of all numerical variables
tab_corr <- con_sqlite \%>\% 
  tbl("TB_IRIS") \%>\% 
  correlate()
  
plot(tab_corr)   
  
# Disconnect DBMS   
DBI::dbDisconnect(con_sqlite)
}

}
\seealso{
\code{\link{correlate}}, \code{\link{summary.correlate}}.
}
