% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{head.zoomed_dm}
\alias{head.zoomed_dm}
\alias{tail.zoomed_dm}
\title{\pkg{utils} table manipulation methods for \code{zoomed_dm} objects}
\usage{
\method{head}{zoomed_dm}(x, n = 6L, ...)

\method{tail}{zoomed_dm}(x, n = 6L, ...)
}
\arguments{
\item{x}{object of class \code{zoomed_dm}}

\item{n}{a single integer.  If positive or zero, size for the resulting
    object: number of elements for a vector (including lists), rows for
    a matrix or data frame or lines for a function.  If negative, all but
    the \code{n} last/first number of elements of \code{x}.}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
A \code{zoomed_dm} object.
}
\description{
Extract the first or last rows from a table.
Use these methods without the '.zoomed_dm' suffix (see examples).
The methods for regular \code{dm} objects extract the first or last tables.
}
\details{
see manual for the corresponding functions in \pkg{utils}.
}
\examples{
zoomed <- dm_nycflights13() \%>\%
  dm_zoom_to(flights) \%>\%
  head(4)
zoomed
dm_insert_zoomed(zoomed, new_tbl_name = "head_flights")
}
