% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{dm_join_to_tbl}
\alias{dm_join_to_tbl}
\title{Join two tables}
\usage{
dm_join_to_tbl(dm, table_1, table_2, join = left_join)
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{table_1}{One of the tables involved in the join.}

\item{table_2}{The second table of the join.}

\item{join}{The type of join to be performed, see \code{\link[dplyr:join]{dplyr::join()}}.}
}
\value{
The resulting table of the join.
}
\description{
A join of a desired type is performed between \code{table_1} and \code{table_2}.
The two tables need to be directly connected by a foreign key relation.
Since this function is a wrapper around \code{\link[=dm_flatten_to_tbl]{dm_flatten_to_tbl()}}, the LHS of
the join will always be a "child table", i.e. a table referencing the other table.
}
\examples{
dm_join_to_tbl(dm_nycflights13(), airports, flights)

# same result is achieved with:
dm_join_to_tbl(dm_nycflights13(), flights, airports)

# this gives an error, because the tables are not directly linked to each other:
try(dm_join_to_tbl(dm_nycflights13(), airlines, airports))
}
\seealso{
Other flattening functions: 
\code{\link{dm_flatten_to_tbl}()}
}
\concept{flattening functions}
