% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_from_con.R
\name{dm_from_con}
\alias{dm_from_con}
\title{Load a dm from a remote data source}
\usage{
dm_from_con(
  con = NULL,
  table_names = NULL,
  learn_keys = NULL,
  .names = NULL,
  ...
)
}
\arguments{
\item{con}{A \code{\link[DBI:DBIConnection-class]{DBI::DBIConnection}} or a \code{Pool} object.}

\item{table_names}{A character vector of the names of the tables to include.}

\item{learn_keys}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Set to \code{TRUE} to query the definition of primary and
foreign keys from the database.
Currently works only for Postgres and SQL Server databases.
The default attempts to query and issues an informative message.}

\item{.names}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A glue specification that describes how to name the tables
within the output, currently only for MSSQL, Postgres and MySQL/MariaDB.
This can use \code{{.table}} to stand for the table name, and
\code{{.schema}} to stand for the name of the schema which the table lives
within. The default (\code{NULL}) is equivalent to \code{"{.table}"} when a single
schema is specified in \code{schema}, and \code{"{.schema}.{.table}"} for the case
where multiple schemas are given, and may change in future versions.}

\item{...}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Additional parameters for the schema learning query.
\itemize{
\item \code{schema}: supported for MSSQL (default: \code{"dbo"}), Postgres (default: \code{"public"}), and MariaDB/MySQL
(default: current database). Learn the tables in a specific schema (or database for MariaDB/MySQL).
\item \code{dbname}: supported for MSSQL. Access different databases on the connected MSSQL-server;
default: active database.
\item \code{table_type}: supported for Postgres (default: \code{"BASE TABLE"}). Specify the table type. Options are:
\enumerate{
\item \code{"BASE TABLE"} for a persistent table (normal table type)
\item \code{"VIEW"} for a view
\item \code{"FOREIGN TABLE"} for a foreign table
\item \code{"LOCAL TEMPORARY"} for a temporary table
}
}}
}
\value{
A \code{dm} object.
}
\description{
\code{dm_from_con()} creates a \link{dm} from some or all tables in a \link{src}
(a database or an environment) or which are accessible via a DBI-Connection.
For Postgres and SQL Server databases, primary and foreign keys
are imported from the database.
}
\examples{
\dontshow{if (dm:::dm_has_financial()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- dm_get_con(dm_financial())

# Avoid DBI::dbDisconnect() here, because we don't own the connection
\dontshow{\}) # examplesIf}
}
