% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{db_schema_list}
\alias{db_schema_list}
\title{List schemas on a database}
\usage{
db_schema_list(con, include_default = TRUE, ...)
}
\arguments{
\item{con}{An object of class \code{"src"} or \code{"DBIConnection"}.}

\item{include_default}{Boolean, if \code{TRUE} (default), also the default schema
on the database is included in the result}

\item{...}{Passed on to the individual methods.}
}
\value{
A tibble with the following columns:
\describe{
\item{\code{schema_name}}{the names of the schemas,}
\item{\code{schema_owner}}{the schema owner names.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{db_schema_list()} lists the available schemas on the database.
}
\details{
Methods are not available for all DBMS.

Additional arguments are:
\itemize{
\item \code{dbname}: supported for MSSQL. List schemas on a different database on the connected MSSQL-server;
default: database addressed by \code{con}.
}
}
\seealso{
Other schema handling functions: 
\code{\link{db_schema_create}()},
\code{\link{db_schema_drop}()},
\code{\link{db_schema_exists}()}
}
\concept{schema handling functions}
