% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_classes.R
\name{update,dmbc_ic-method}
\alias{update,dmbc_ic-method}
\alias{dmbc_ic-update}
\title{Provide an update of a \code{dmbc_ic} class instance.}
\usage{
\S4method{update}{dmbc_ic}(object, pmax = NULL, Gmax = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{\link{dmbc_ic}}.}

\item{pmax}{A length-one numeric vector indicating the maximum number of
dimensions of the latent space to consider.}

\item{Gmax}{A length-one numeric vector indicating the maximum number of
cluster to consider.}

\item{...}{Further arguments to pass on (currently ignored).}
}
\value{
A \code{dmbc_ic} object.
}
\description{
Provide an update of a \code{dmbc_ic} class instance.
}
\examples{
\donttest{
data(simdiss, package = "dmbc")

pmax <- 2
Gmax <- 2
prm.prop <- list(z = 1.5, alpha = .75)
burnin <- 2000
nsim <- 1000
seed <- 1809

set.seed(seed)

control <- list(burnin = burnin, nsim = nsim, z.prop = prm.prop[["z"]],
  alpha.prop = prm.prop[["alpha"]], random.start = TRUE, verbose = TRUE,
  thin = 10, store.burnin = TRUE)
sim.ic <- dmbc_IC(data = simdiss, pmax = pmax, Gmax = Gmax, control = control,
  est = "mean")

pmax <- pmax + 1
Gmax <- Gmax + 2
new.ic <- update(sim.ic, pmax = pmax, Gmax = Gmax)
new.ic

# plot the results
library(bayesplot)
library(ggplot2)
color_scheme_set("mix-yellow-blue")
p <- plot(new.ic, size = c(4, 1.5))
p + panel_bg(fill = "gray90", color = NA)
}

}
\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
\seealso{
\code{\link{dmbc}()} for fitting a DMBC model.

\code{\link{dmbc_ic}} for a description of the elements included
  in the returned object.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
