% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{dmbc_fit_list_to_mcmc.list}
\alias{dmbc_fit_list_to_mcmc.list}
\title{Conversion of an \code{dmbc_fit_list} object to an object of class
  \code{mcmc.list}.}
\usage{
dmbc_fit_list_to_mcmc.list(res, include.burnin = FALSE, verbose = TRUE)
}
\arguments{
\item{res}{An object of type \code{dmbc_fit_list}.}

\item{include.burnin}{A logical scalar. If \code{TRUE} the burnin
iterations (if available) are not removed.}

\item{verbose}{A logical scalar. If \code{TRUE} prints additional
warnings during the conversion.}
}
\value{
An object of type \code{mcmc.list}.
}
\description{
\code{dmbc_fit_list_to_mcmc.list} converts an object of class
  \code{dmbc_fit_list} to an object with class \code{mcmc.list}.
}
\examples{
\dontrun{
data(simdiss, package = "dmbc")

G <- 3
p <- 2
prm.prop <- list(z = 1.5, alpha = .75)
burnin <- 2000
nsim <- 1000
seed <- 2301

set.seed(seed)

control <- list(burnin = burnin, nsim = nsim, z.prop = prm.prop[["z"]],
  alpha.prop = prm.prop[["alpha"]], nchains = 2, verbose = TRUE)
sim.dmbc <- dmbc(simdiss, p, G, control)
sim.mcmc <- dmbc_fit_list_to_mcmc.list(sim.dmbc, TRUE)
plot(sim.mcmc)
}
}
\seealso{
\code{\link{dmbc}()} for for fitting a DMBC model;
  \code{\link{dmbc_fit_list-class}};
  \code{\link[coda]{mcmc.list}}.
}
\author{
Sergio Venturini \email{sergio.venturini@unicatt.it}
}
