% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome.R
\name{get_reactome_pathways}
\alias{get_reactome_pathways}
\title{Obtain Reactome pathways}
\usage{
get_reactome_pathways(species, overlap_limit = 0.9, min_size = 10,
  max_size = 50, verbose = TRUE)
}
\arguments{
\item{species}{A string, for example "Homo sapiens" or "Mus musculus",
indicating the species to use.}

\item{overlap_limit}{(Optional) Any pathways that have an overlap
greater than overlap_limit are combined. Set to NULL to disable
this option.}

\item{min_size}{The minimum pathway size. Any Reactome pathways with fewer
than \code{min_size} genes are removed from the list. Defaults to 10.}

\item{max_size}{The maximum pathway size. Any Reactome pathways with more
than \code{max_size} genes are removed from the list. Defaults to 50.}

\item{verbose}{Set to FALSE to turn off messages.}
}
\value{
A named list of vectors. Each vector corresponds to a Reactome pathway
and contains the entrezgene IDs of the genes in that pathway.
}
\description{
Connects to \code{reactome.db} \insertCite{reactome}{dnapath}
to obtain a list of pathways for a given species.
The pathway list is processed by combining any two pathways that have
substantial overlap (default is over 90% overlap). This output if this
function can be used for the \code{pathway_list} argument in
\code{\link{dnapath}}.
}
\examples{
# Obtaining a pathway list for human (Homo sapiens).
# In this example, overlapping pathways are not combined (this is
# specified by setting overlap_limit to NULL).
pathway_list <- get_reactome_pathways("Homo sapiens", overlap_limit = NULL,
                                      min_size = 10, max_size = 20)
}
\references{
\insertRef{reactome}{dnapath}
}
\seealso{
The genes in the Reactome pathways use entrezgene IDs. These can be converted
to gene symbols, if desired, using the \code{\link{entrez_to_symbol}} and
\code{\link{rename_genes}} functions.
}
