% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{splitn_kurtosis}
\alias{splitn_kurtosis}
\alias{splitn_moments}
\alias{splitn_mean}
\alias{splitn_skewness}
\alias{splitn_var}
\title{Moments of the split normal distribution}
\usage{
splitn_kurtosis(lmd)

splitn_mean(mu, sigma, lmd)

splitn_skewness(sigma, lmd)

splitn_var(sigma, lmd)
}
\arguments{
\item{lmd}{vector of skewness parameters (>0). If is 1, reduce to normal
distribution.}

\item{mu}{vector of location parameter. (The mode of the density)}

\item{sigma}{vector of standard deviations.}
}
\value{
\code{splitn_mean} gives the mean.  \code{splitn_var} gives the
variance.  \code{splitn_skewness} gives the skewness.
\code{splitn_kurtosis} gives the kurtosis.  (\code{splitn_mean},
\code{splitn_var},\code{splitn_skeness} and \code{splitn_kurtosis} are all
vectors.
}
\description{
Computing the mean, variance, skewness and kurtosis for the split-normal
distribution.
}
\section{Functions}{
\itemize{
\item \code{splitn_kurtosis}: Kurtosis for the split-normal distribution.

\item \code{splitn_skewness}: Skewness for the split-normal distribution.

\item \code{splitn_var}: Variance for the split-normal distribution.
}}

\examples{

mu <- c(0,1,2)
sigma <- c(0.5,1,2)
lmd <- c(1,2,3)

mean0 <- splitn_mean(mu, sigma, lmd)
var0 <- splitn_var(sigma, lmd)
skewness0 <- splitn_skewness(sigma, lmd)
kurtosis0 <- splitn_kurtosis(lmd)
}
\references{
Villani, M., & Larsson, R. (2006) The Multivariate Split Normal
Distribution and Asymmetric Principal Components Analysis. Sveriges
Riksbank Working Paper Series, No. 175.
}
\seealso{
\code{\link{psplitn}()} \code{\link{dsplitn}()} \code{\link{qsplitn}()} and
\code{\link{rsplitn}()} for the split-normal distribution.
}
\author{
Feng Li, Jiayue Zeng
}
\keyword{asymmetric}
\keyword{distribution}
\keyword{normal}
