% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI_imputation.R
\name{MImpute}
\alias{MImpute}
\alias{MImpute_surv}
\alias{MImpute_lcens}
\alias{MImpute_lcenssurv}
\title{Wrapper functions for multivariate imputation with survival data or
left-censored data}
\usage{
MImpute(
  data,
  mi.m,
  method = NULL,
  predMat = NULL,
  maxit = 10,
  return.midsObject = FALSE
)

MImpute_surv(
  data,
  mi.m,
  time.status.names = c("time", "status"),
  return.midsObject = FALSE
)

MImpute_lcens(
  data,
  data.lod,
  standards,
  mi.m,
  mice.log = 10,
  maxit = 10,
  return.midsObject = FALSE
)

MImpute_lcenssurv(
  data,
  mi.m,
  time.status.names = c("time", "status"),
  data.lod,
  standards,
  mice.log = 10,
  var.log = NULL,
  maxit = 10,
  return.midsObject = FALSE
)
}
\arguments{
\item{data}{Dataframe with incomplete data. (for \code{MImpute_lcens()}, with
\code{NA} for both missing and left-censored data).}

\item{mi.m}{Number of imputations to perform.}

\item{method}{Optional.  single string, or a vector of strings specifying
the imputation method to be used for each column in data
(passed to \code{mice()}). If \code{NULL} default mice setting are used.}

\item{predMat}{Optional. supply a \code{predictorMatrix} (passed to
\code{mice()}). If \code{NULL} default mice setting are used.}

\item{maxit}{passed to \code{mice()}.}

\item{return.midsObject}{Boolean}

\item{time.status.names}{Names of the variables for time and status
(in that order).}

\item{data.lod}{Dataframe containing indicators of which observation are
left-censored (censoring value for such observations and any other values
for not censored observations). The colnames should correspond to variables
in \code{data}. The variables that are left-censored are
thus given in \code{data} (with left-censored data as \code{NA}) and in
\code{data.lod} with random values for observed data and the LOD for
left-censored data. Note that if the data are to be logged
(\code{is.numeric(mice.log)}), only the argument \code{data} will be
logged,  therefore, the LOD values given here should be given as
\code{log(LOD)} with the correct number of decimals:
\code{round(log(LOD), mice.log)}.}

\item{standards}{Dataframe of 1 row containing the LOD values (not logged,
whatever the value for \code{mice.log}).}

\item{mice.log}{set to \code{FALSE} if the imputation should be performed on
unlogged data. Otherwise, number of decimal to save after taking the log of
data (should be 10 unless for specific reasons) ; in that case the data will
be unlogged after imputation.}

\item{var.log}{names of variables to log if \code{mice.log} is numeric. If
\code{NULL}, all variables but those in  \code{time.status.names} will be
logged.}
}
\value{
If \code{return.midsObject == FALSE} a list of size mi.m, containing
the imputed datasets. If \code{return.midsObject == TRUE} a list of 2, the
first element (\code{imputed.data}) being the list of size mi.m as
described in the previous sentence, the 2nd element (\code{mids.obj})
containing the \code{mids} object as returned by \code{mice()}
}
\description{
Performs imputation of the missing data using MICE and returns a list in the
correct format for the \code{unsupMI()} and \code{seMIsupcox()}functions.
\code{MImpute()} performs imputation for datasets with missing data only.
\code{MImpute_surv()} performs imputation for a dataset with survival data.
The Nelson Aalen estimator is calculated and used as predictor in the
imputation, Time is not used as predictor.
\code{MImpute_lcens()} performs imputation for a dataset with left-censored
data. Note that with \code{MImpute_lcens()} pmm imputation is
performed for variables not affected by left-censoring.
}
\examples{
data(cancer, package = "survival")
cancer.imp <- MImpute(cancer[, -c(1:3)], 2)

## MImpute_surv
data(cancer, package = "survival")
cancer$status <- cancer$status - 1
cancer.imp <- MImpute_surv(cancer, 1)

## MImpute_lcens
toy <- iris[, 1:4]
# censor on variables 3 and 4, with LOD at quantile .1 and .2.
LODs <- toy[1, ]
LODs[1, ] <-c(NA, NA, quantile(toy[,3], .2), quantile(toy[,4], .1))
# Censor indicator
Censored <- data.frame(Petal.Length = runif(150, 50,60),
                       Petal.Width = runif(150, 50,60))
Censored[toy[,3] < LODs[1, 3], 1] <- LODs[1, 3]
Censored[toy[,4] < LODs[1, 4], 2] <- LODs[1, 4]
# NA for censored data
toy[toy[,3] < LODs[1, 3], 3] <- NA
toy[toy[,4] < LODs[1, 4], 4] <- NA
# Additional missing data
toy[sample(1:nrow(toy), 30), 1] <- NA
toy[sample(1:nrow(toy), 30), 3] <- NA
toy[sample(1:nrow(toy), 30), 4] <- NA

toy.imp <- MImpute_lcens(data = toy, data.lod = Censored, standards = LODs,
                         mi.m = 1, mice.log = FALSE)
## MImpute_lcenssurv
data(cancer, package = "survival")
cancer$status <- cancer$status - 1
toy2 <- cancer[, -1]
# censor on variables age and meal.cal, with LOD at quantile .1 and .2.
LODs <- toy2[1, ]
LODs[1, ] <-c(NA, NA, quantile(toy2[, "age"], .2, na.rm = TRUE), NA,  NA,
              NA, NA, quantile(toy2[, "meal.cal"], .1, na.rm = TRUE), NA)
# Censor indicator
Censored <- data.frame(age = runif(nrow(toy2), 300,400),
                       meal.cal = runif(nrow(toy2), 50,60))
Censored[toy2[, "age"] < LODs[1, "age"], "age"] <- LODs[1, "age"]
Censored[!is.na(toy2[, "meal.cal"]) &
           toy2[, "meal.cal"] < LODs[1, "meal.cal"], "meal.cal"] <-
 LODs[1, "meal.cal"]
# NA for censored data
toy2[toy2[, "age"] < LODs[1, "age"], "age"] <- NA
toy2[!is.na(toy2[, "meal.cal"]) &
      toy2[, "meal.cal"] < LODs[1, "meal.cal"],"meal.cal"] <- NA
# Additional missing data
toy2[sample(1:nrow(toy2), 30), 6] <- NA
toy2[sample(1:nrow(toy2), 30), 3] <- NA
toy2[sample(1:nrow(toy2), 30), 4] <- NA
toy2$sex <- factor(toy2$sex)
toy2$ph.ecog <- factor(toy2$ph.ecog)

toy2.imp <- MImpute_lcenssurv(
  data = toy2, mi.m = 1, data.lod = Censored, standards = LODs,
  mice.log = FALSE)

}
