% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_continous.R
\name{table_continuous}
\alias{table_continuous}
\title{Display table with comparison of the partition with continuous variables.}
\usage{
table_continuous(
  data,
  partition.name,
  vars.cont,
  vars.cont.names = NULL,
  na.value = "",
  nb.dec = 1,
  text.pval = FALSE
)
}
\arguments{
\item{data}{The dataset.}

\item{partition.name}{string. Name of the partition (in data). The partition
variable should be a factor.}

\item{vars.cont}{vector of strings. variables to compare to (continuous
only).}

\item{vars.cont.names}{Optional. Names for displaying the continuous
variables. (in the same order than \code{vars.cont})}

\item{na.value}{Value to use for the empty cases (e.g. \code{""} or
\code{NA}).}

\item{nb.dec}{digit. Number of decimals for the mean and quartile values.}

\item{text.pval}{boolean. Set to \code{TRUE}to display \code{"p="}, to
\code{FALSE} to display only the value.}
}
\value{
table with mean and Q1 Q3 values per level of the partition and
ANOVA test p-values.
}
\description{
Display table with comparison of the partition with continuous variables.
}
\examples{
data(cancer, package = "survival")
cancer$status <- factor(cancer$status)
table_continuous(data = cancer, partition.name = "status",
                  vars.cont = c("age", "meal.cal", "wt.loss"))
}
