% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_lines_to_file.R
\name{write_lines_to_file}
\alias{write_lines_to_file}
\title{Write Lines to File}
\usage{
write_lines_to_file(lines, filepath = "", prepend = FALSE,
  print_file = TRUE)
}
\arguments{
\item{lines}{\code{character} lines that will be written to file.}

\item{filepath}{\code{character} filepath of file to write lines to.}

\item{prepend}{\code{logical} should the new lines be prepended to
the existing text? Defaults to FALSE, which implies that the new lines will
be appended.}

\item{print_file}{\code{logical} should the contents of the file be printed
after editing? Defaults to TRUE.}
}
\value{
invisible return. Lines will be written to file as side effects to
function call.
}
\description{
Write Lines to File
}
\examples{
# create empty file.
fp <- file.path(tempdir(), "dummy")
file.create(fp)

# append lines to Dockerfile.
write_lines_to_file(c("# dummy line 1", "# dummy line 2"), 
filepath = fp)

# prepend lines to Dockerfile.
write_lines_to_file(c("# dummy line 3", "# dummy line 4"), 
filepath = fp, prepend = TRUE)
}
