% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examine.R
\name{examine}
\alias{examine}
\title{EDA automator}
\usage{
examine(X, group = 0)
}
\arguments{
\item{X}{Table to be examined}

\item{group}{A variable (name or index) to group X by before examining}
}
\description{
Creates summary statistics for every column of \code{X}, varying
  summarization strategy depending on the type of variable
}
\details{
This function determines the types of the variables in
  \code{X} (numeric, text or factor) and creates a report
  for each type of variable; these reports can be accessed
  with \code{report_[num|txt|fct]()} and more information
  about these are available at \code{vignette("doctr_examine")}
}
\examples{
\dontrun{
library(tidyverse)
  
# Creating automated EDA from table
eda <- txhousing \%>\% examine()
  
# Fetching EDA for numeric variables
report_num(eda)
  
# Creating and fetching automated EDA with grouping
eda <- txhousing \%>\% examine("city")
report_num(eda, "Austin")
}

}
