% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clean_description_file}
\alias{clean_description_file}
\title{Make a Default DESCRIPTION File Pass \command{R CMD check}}
\usage{
clean_description_file(path)
}
\arguments{
\item{path}{Path to the DESCRIPTION file or the directory containing it.}
}
\value{
value of \code{\link{alter_description_file}}.
}
\description{
\code{utils::\link[utils]{package.skeleton}} leaves us with a DESCRIPTION 
that throws a warning in \command{R CMD check}. Fix that.
}
\examples{
utils::package.skeleton(path = tempdir())
old <- readLines(file.path(tempdir(), "anRpackage", "DESCRIPTION"))
clean_description_file(path = file.path(tempdir(), "anRpackage", 
                                        "DESCRIPTION"))
new <- readLines(file.path(tempdir(), "anRpackage", "DESCRIPTION"))
setdiff(new, old)
}
