% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/extract_all.r
\name{docx_extract_all}
\alias{docx_extract_all}
\title{Extract all tables from a Word document}
\usage{
docx_extract_all(docx, guess_header = TRUE, trim = TRUE)
}
\arguments{
\item{docx}{\code{docx} object read with \code{read_docx}}

\item{guess_header}{should the function make a guess as to the existense of
a header in a table? (Default: \code{TRUE})}

\item{trim}{trim leading/trailing whitespace (if any) in cells? (default: \code{TRUE})}
}
\value{
\code{list} of \code{data.frame}s or an empty \code{list} if no
        tables exist in \code{docx}
}
\description{
This function makes no assumptions about an
}
\examples{
# a "real" Word doc

real_world <- read_docx(system.file("examples/realworld.docx", package="docxtractr"))
docx_tbl_count(real_world)

# get all the tables
tbls <- docx_extract_all(real_world)
}
\seealso{
\code{\link{assign_colnames}}, \code{\link{docx_extract_tbl}}
}

