% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_credit_analysis.R
\name{partial_credit_analysis}
\alias{partial_credit_analysis}
\title{Partial credit analysis for DOOR}
\usage{
partial_credit_analysis(
  grade_key,
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  summary_obj = NULL,
  data_type = c("freq", "prop"),
  ci_method = "halperin",
  conf_level = 0.95,
  ...
)
}
\arguments{
\item{grade_key}{A numeric vector of grade key or a dataframe contains columns of grade keys}

\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if method = "prop"}

\item{summary_obj}{An object returned by \code{door_summary()}; Alternative
input for y1 and y2}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{ci_method}{Specify the type of CI for DOOR probability given a grade key.
The default is "halperin" for Halperin et al. (1989)'s
method. Other options include "ps_h" for pseudo-score approach for Halperin's method and
"tanh" for inverse hyperbolc tangent transformed method}

\item{conf_level}{Confidence level}

\item{...}{Optional additional parameters if \code{ci_method = "ps_h"}}
}
\value{
An object containing information of partial credit analysis given grade keys
}
\description{
Partial credit analysis for DOOR
}
\examples{
grade.key <- c(100, 80, 60, 40, 0)
y1 <- c(60, 30, 20, 10, 5)
y2 <- c(50, 40, 10, 20, 5)
partial_credit_analysis(grade_key = grade.key, y1 = y1, y2 = y2)
}
