% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{plot.doremi}
\alias{plot.doremi}
\title{S3 method to plot DOREMI objects}
\usage{
\method{plot}{doremi}(x, ..., id = NULL)
}
\arguments{
\item{x}{DOREMI object from \code{\link{remi}} analysis}

\item{...}{includes the additional arguments inherited from the generic plot method}

\item{id}{Identifiers of the individuals to be represented in the plot.
By default, it will print the first six individuals.}
}
\value{
Returns a plot with axis labels, legend and title. The axis labels and legend include the names of the variables set as input arguments.
The title includes the name of the DOREMI object result of the analysis. The function uses \code{\link[ggplot2]{ggplot}}
to generate the graphs and so it is possible to override the values of axis labels, legend and title through ggplot commands.
}
\description{
\code{plot.doremi} generates a plot with the observed values of the signal, the excitation values and the fitted
signal over time for each individual.
}
\examples{
mydata <- generate.panel.remi(nind = 2,
                           dampingtime = 10,
                           amplitude = c(5,10),
                           nexc = 2,
                           duration = 20,
                           deltatf = 2,
                           tmax = 200,
                           minspacing = 0,
                           internoise = 0.2,
                           intranoise = 0.1)
myresult <- remi(data = mydata,
                 id = "id",
                 input = "excitation",
                 time = "time",
                 signal = "dampedsignal",
                 embedding = 5)
plot(myresult)
}
