% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_Plot_doublIn.R
\name{Plot_doublIn}
\alias{Plot_doublIn}
\title{Plot the incubation or latency time distribution}
\usage{
Plot_doublIn(
  doublIn_obj,
  label_x = "Days since infection",
  label_y = "Probability",
  p_shaded = 2,
  p_linepieces = c(0.5, 0.9, 0.95)
)
}
\arguments{
\item{doublIn_obj}{output list from function Estimate_doublIn containing
parameter estimates.}

\item{label_x}{Label for the x-axis.}

\item{label_y}{Label for the y-axis.}

\item{p_shaded}{Which area needs to be shaded, i.e. enclosed by which
percentile from the vector p_linepieces (1, 2 or 3).}

\item{p_linepieces}{Percentiles to indicate by vertical line pieces, given
as vector of length three with probabilities between 0 and 1.}
}
\value{
Plot of the estimated probability density function.
}
\description{
Plot the estimated probability density function using a doublIn output
object.
}
\details{
The function plots the estimated probability density function using the
parameterisation of the generalized gamma distribution by Stacy et al. that
includes the gamma and Weibull distributions as a special case.
}
\references{
Stacy, E. W., and G. A. Mihram, Parameter estimation for a
generalized gamma distribution, Technometrics, 7 (3), 349–358,
doi:10.1080/00401706.1965.10490268, 1965
}
\author{
Vera Arntzen, \email{v.h.arntzen@math.leidenuniv.nl}
}
\keyword{survival}
