% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downlit-package.R
\docType{package}
\name{downlit-package}
\alias{downlit}
\alias{downlit-package}
\title{downlit: Syntax Highlighting and Automatic Linking}
\description{
Syntax highlighting of R code, specifically designed
    for the needs of 'RMarkdown' packages like 'pkgdown', 'hugodown', and
    'bookdown'. It includes linking of function calls to their documentation
    on the web, and automatic translation of ANSI escapes in output to the
    equivalent HTML.
}
\section{Options}{


downlit provides a number of options to control the details of the linking.
They are particularly important if you want to generate "local" links.
\itemize{
\item \code{downlit.package}: name of the current package. Determines when
\code{topic_index} and \code{article_index}
\item \code{downlit.topic_index} and \code{downlit.article_index}: named character
vector that maps from topic/article name to path.
\item \code{downlit.rdname}: name of current Rd file being documented (if any);
used to avoid self-links.
\item \code{downlit.attached}: character vector of currently attached R packages.
\item \code{downlit.local_packages}: named character vector providing relative
paths (value) to packages (name) that can be reached with relative links
from the target HTML document.
\item \code{downlit.topic_path} and \code{downlit.article_path}: paths to reference
topics and articles/vignettes relative to the "current" file.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/downlit}
  \item Report bugs at \url{https://github.com/r-lib/downlit/issues}
}

}
\author{
\strong{Maintainer}: Hadley Wickham \email{hadley@rstudio.com}

Other contributors:
\itemize{
  \item RStudio [copyright holder]
}

}
\keyword{internal}
